/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LineBreakElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class MetricOptions {
    private static final String NAMED_REPORTER_CONFIG_PREFIX = "metrics.reporter.<name>";
    public static final ConfigOption<String> REPORTERS_LIST = ConfigOptions.key("metrics.reporters").stringType().noDefaultValue().withDescription("An optional list of reporter names. If configured, only reporters whose name matches any of the names in the list will be started. Otherwise, all reporters that could be found in the configuration will be started.");
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=1)
    public static final ConfigOption<String> REPORTER_FACTORY_CLASS = ConfigOptions.key("factory.class").stringType().noDefaultValue().withDescription("The reporter factory class to use for the reporter named <name>.");
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=2)
    public static final ConfigOption<Duration> REPORTER_INTERVAL = ConfigOptions.key("interval").durationType().defaultValue(Duration.ofSeconds(10L)).withDescription("The reporter interval to use for the reporter named <name>. Only applicable to push-based reporters.");
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=2)
    public static final ConfigOption<String> REPORTER_SCOPE_DELIMITER = ConfigOptions.key("scope.delimiter").stringType().defaultValue(".").withDescription("The delimiter used to assemble the metric identifier for the reporter named <name>.");
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=3)
    public static final ConfigOption<Map<String, String>> REPORTER_ADDITIONAL_VARIABLES = ConfigOptions.key("scope.variables.additional").mapType().defaultValue(Collections.emptyMap()).withDescription("The map of additional variables that should be included for the reporter named <name>. Only applicable to tag-based reporters.");
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=3)
    public static final ConfigOption<String> REPORTER_EXCLUDED_VARIABLES = ConfigOptions.key("scope.variables.excludes").stringType().defaultValue(".").withDescription("The set of variables that should be excluded for the reporter named <name>. Only applicable to tag-based reporters.");
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=4)
    public static final ConfigOption<List<String>> REPORTER_INCLUDES = ConfigOptions.key("filter.includes").stringType().asList().defaultValues((String[])new String[]{"*:*:*"}).withDescription(Description.builder().text("The metrics that should be included for the reporter named <name>. Filters are specified as a list, with each filter following this format:").linebreak().text("%s", TextElement.code("<scope>[:<name>[,<name>][:<type>[,<type>]]]")).linebreak().text("A metric matches a filter if the scope pattern and at least one of the name patterns and at least one of the types match.").linebreak().list(TextElement.text("scope: Filters based on the logical scope.%sSpecified as a pattern where %s matches any sequence of characters and %s separates scope components.%s%sFor example:%s \"%s\" matches any job-related metrics on the JobManager,%s \"%s\" matches all job-related metrics and%s \"%s\" matches all metrics below the job-level (i.e., task/operator metrics etc.).%s%s", LineBreakElement.linebreak(), TextElement.code("*"), TextElement.code("."), LineBreakElement.linebreak(), LineBreakElement.linebreak(), LineBreakElement.linebreak(), TextElement.code("jobmanager.job"), LineBreakElement.linebreak(), TextElement.code("*.job"), LineBreakElement.linebreak(), TextElement.code("*.job.*"), LineBreakElement.linebreak(), LineBreakElement.linebreak()), TextElement.text("name: Filters based on the metric name.%sSpecified as a comma-separate list of patterns where %s matches any sequence of characters.%s%sFor example, \"%s\" matches any metrics where the name contains %s.%s%s", LineBreakElement.linebreak(), TextElement.code("*"), LineBreakElement.linebreak(), LineBreakElement.linebreak(), TextElement.code("*Records*,*Bytes*"), TextElement.code("\"Records\" or \"Bytes\""), LineBreakElement.linebreak(), LineBreakElement.linebreak()), TextElement.text("type: Filters based on the metric type. Specified as a comma-separated list of metric types: %s", TextElement.code("[counter, meter, gauge, histogram]"))).text("Examples:").list(TextElement.text("\"%s\" Matches metrics like %s.", TextElement.code("*:numRecords*"), TextElement.code("numRecordsIn")), TextElement.text("\"%s\" Matches metrics like %s on the operator level.", TextElement.code("*.job.task.operator:numRecords*"), TextElement.code("numRecordsIn")), TextElement.text("\"%s\" Matches meter metrics like %s on the operator level.", TextElement.code("*.job.task.operator:numRecords*:meter"), TextElement.code("numRecordsInPerSecond")), TextElement.text("\"%s\" Matches all counter/meter metrics like or %s.", TextElement.code("*:numRecords*,numBytes*:counter,meter"), TextElement.code("numRecordsInPerSecond"), TextElement.code("numBytesOut"))).build());
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=5)
    public static final ConfigOption<List<String>> REPORTER_EXCLUDES = ConfigOptions.key("filter.excludes").stringType().asList().defaultValues((String[])new String[0]).withDescription(Description.builder().text("The metrics that should be excluded for the reporter named <name>. The format is identical to %s", TextElement.code(REPORTER_INCLUDES.key())).linebreak().build());
    @Documentation.SuffixOption(value="metrics.reporter.<name>")
    @Documentation.Section(value={"metric_reporters"}, position=6)
    public static final ConfigOption<String> REPORTER_CONFIG_PARAMETER = ConfigOptions.key("<parameter>").stringType().noDefaultValue().withDescription("Configures the parameter <parameter> for the reporter named <name>.");
    public static final ConfigOption<String> SCOPE_DELIMITER = ConfigOptions.key("metrics.scope.delimiter").stringType().defaultValue(".").withDescription("Delimiter used to assemble the metric identifier.");
    public static final ConfigOption<String> SCOPE_NAMING_JM = ConfigOptions.key("metrics.scope.jm").stringType().defaultValue("<host>.jobmanager").withDescription("Defines the scope format string that is applied to all metrics scoped to a JobManager. Only effective when a identifier-based reporter is configured.");
    public static final ConfigOption<String> SCOPE_NAMING_TM = ConfigOptions.key("metrics.scope.tm").stringType().defaultValue("<host>.taskmanager.<tm_id>").withDescription("Defines the scope format string that is applied to all metrics scoped to a TaskManager. Only effective when a identifier-based reporter is configured");
    public static final ConfigOption<String> SCOPE_NAMING_JM_JOB = ConfigOptions.key("metrics.scope.jm-job").stringType().defaultValue("<host>.jobmanager.<job_name>").withDeprecatedKeys("metrics.scope.jm.job").withDescription("Defines the scope format string that is applied to all metrics scoped to a job on a JobManager. Only effective when a identifier-based reporter is configured");
    public static final ConfigOption<String> SCOPE_NAMING_JM_OPERATOR = ConfigOptions.key("metrics.scope.jm-operator").stringType().defaultValue("<host>.jobmanager.<job_name>.<operator_name>").withDescription("Defines the scope format string that is applied to all metrics scoped to the components running on a JobManager of an Operator, like OperatorCoordinator for Source Enumerator metrics.");
    public static final ConfigOption<String> SCOPE_NAMING_TM_JOB = ConfigOptions.key("metrics.scope.tm-job").stringType().defaultValue("<host>.taskmanager.<tm_id>.<job_name>").withDeprecatedKeys("metrics.scope.tm.job").withDescription("Defines the scope format string that is applied to all metrics scoped to a job on a TaskManager. Only effective when a identifier-based reporter is configured");
    public static final ConfigOption<String> SCOPE_NAMING_TASK = ConfigOptions.key("metrics.scope.task").stringType().defaultValue("<host>.taskmanager.<tm_id>.<job_name>.<task_name>.<subtask_index>").withDescription("Defines the scope format string that is applied to all metrics scoped to a task. Only effective when a identifier-based reporter is configured");
    public static final ConfigOption<String> SCOPE_NAMING_OPERATOR = ConfigOptions.key("metrics.scope.operator").stringType().defaultValue("<host>.taskmanager.<tm_id>.<job_name>.<operator_name>.<subtask_index>").withDescription("Defines the scope format string that is applied to all metrics scoped to an operator. Only effective when a identifier-based reporter is configured");
    public static final ConfigOption<Duration> LATENCY_INTERVAL = ConfigOptions.key("metrics.latency.interval").durationType().defaultValue(Duration.ofMillis(0L)).withDescription("Defines the interval at which latency tracking marks are emitted from the sources. Disables latency tracking if set to 0 or a negative value. Enabling this feature can significantly impact the performance of the cluster.");
    public static final ConfigOption<String> LATENCY_SOURCE_GRANULARITY = ConfigOptions.key("metrics.latency.granularity").stringType().defaultValue("operator").withDescription(Description.builder().text("Defines the granularity of latency metrics. Accepted values are:").list(TextElement.text("single - Track latency without differentiating between sources and subtasks."), TextElement.text("operator - Track latency while differentiating between sources, but not subtasks."), TextElement.text("subtask - Track latency while differentiating between sources and subtasks.")).build());
    public static final ConfigOption<Integer> LATENCY_HISTORY_SIZE = ConfigOptions.key("metrics.latency.history-size").intType().defaultValue(128).withDescription("Defines the number of measured latencies to maintain at each operator.");
    public static final ConfigOption<Boolean> SYSTEM_RESOURCE_METRICS = ConfigOptions.key("metrics.system-resource").booleanType().defaultValue(false).withDescription("Flag indicating whether Flink should report system resource metrics such as machine's CPU, memory or network usage.");
    public static final ConfigOption<Duration> SYSTEM_RESOURCE_METRICS_PROBING_INTERVAL = ConfigOptions.key("metrics.system-resource-probing-interval").durationType().defaultValue(Duration.ofMillis(5000L)).withDescription("Interval between probing of system resource metrics specified. Has an effect only when '" + SYSTEM_RESOURCE_METRICS.key() + "' is enabled.");
    @Documentation.Section(value={"common_host_port"})
    public static final ConfigOption<String> QUERY_SERVICE_PORT = ConfigOptions.key("metrics.internal.query-service.port").stringType().defaultValue("0").withDescription("The port range used for Flink's internal metric query service. Accepts a list of ports (\u201c50100,50101\u201d), ranges(\u201c50100-50200\u201d) or a combination of both. It is recommended to set a range of ports to avoid collisions when multiple Flink components are running on the same machine. Per default Flink will pick a random port.");
    public static final ConfigOption<Integer> QUERY_SERVICE_THREAD_PRIORITY = ConfigOptions.key("metrics.internal.query-service.thread-priority").intType().defaultValue(1).withDescription("The thread priority used for Flink's internal metric query service. The thread is created by Pekko's thread pool executor. The range of the priority is from 1 (MIN_PRIORITY) to 10 (MAX_PRIORITY). Warning, increasing this value may bring the main Flink components down.");
    public static final ConfigOption<Duration> METRIC_FETCHER_UPDATE_INTERVAL = ConfigOptions.key("metrics.fetcher.update-interval").durationType().defaultValue(Duration.ofMillis(10000L)).withDescription("Update interval for the metric fetcher used by the web UI. Decrease this value for faster updating metrics. Increase this value if the metric fetcher causes too much load. Setting this value to 0 disables the metric fetching completely.");
    public static final ConfigOption<List<JobStatusMetrics>> JOB_STATUS_METRICS = ConfigOptions.key("metrics.job.status.enable").enumType(JobStatusMetrics.class).asList().defaultValues((JobStatusMetrics[])new JobStatusMetrics[]{JobStatusMetrics.CURRENT_TIME}).withDescription("The selection of job status metrics that should be reported.");

    @Experimental
    public static Configuration forReporter(Configuration configuration, String reporterName) {
        return new DelegatingConfiguration(configuration, "metrics.reporter." + reporterName + ".");
    }

    private MetricOptions() {
    }

    public static final class JobStatusMetricsSettings {
        private final boolean stateMetricsEnabled;
        private final boolean currentTimeMetricsEnabled;
        private final boolean totalTimeMetricsEnabled;

        private JobStatusMetricsSettings(boolean stateMetricsEnabled, boolean currentTimeMetricsEnabled, boolean totalTimeMetricsEnabled) {
            this.stateMetricsEnabled = stateMetricsEnabled;
            this.currentTimeMetricsEnabled = currentTimeMetricsEnabled;
            this.totalTimeMetricsEnabled = totalTimeMetricsEnabled;
        }

        public boolean isStateMetricsEnabled() {
            return this.stateMetricsEnabled;
        }

        public boolean isCurrentTimeMetricsEnabled() {
            return this.currentTimeMetricsEnabled;
        }

        public boolean isTotalTimeMetricsEnabled() {
            return this.totalTimeMetricsEnabled;
        }

        public static JobStatusMetricsSettings fromConfiguration(Configuration configuration) {
            List<JobStatusMetrics> jobStatusMetrics = configuration.get(JOB_STATUS_METRICS);
            boolean stateMetricsEnabled = false;
            boolean currentTimeMetricsEnabled = false;
            boolean totalTimeMetricsEnabled = false;
            for (JobStatusMetrics jobStatusMetric : jobStatusMetrics) {
                switch (jobStatusMetric) {
                    case STATE: {
                        stateMetricsEnabled = true;
                        break;
                    }
                    case CURRENT_TIME: {
                        currentTimeMetricsEnabled = true;
                        break;
                    }
                    case TOTAL_TIME: {
                        totalTimeMetricsEnabled = true;
                    }
                }
            }
            return new JobStatusMetricsSettings(stateMetricsEnabled, currentTimeMetricsEnabled, totalTimeMetricsEnabled);
        }
    }

    public static enum JobStatusMetrics implements DescribedEnum
    {
        STATE("For a given state, return 1 if the job is currently in that state, otherwise return 0."),
        CURRENT_TIME("For a given state, if the job is currently in that state, return the time since the job transitioned into that state, otherwise return 0."),
        TOTAL_TIME("For a given state, return how much time the job has spent in that state in total.");

        private final String description;

        private JobStatusMetrics(String description) {
            this.description = description;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }
}

