/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.NullFieldException;

@Internal
public class TupleSerializer<T extends Tuple>
extends TupleSerializerBase<T> {
    private static final long serialVersionUID = 1L;
    private transient Constructor<T> constructor;

    public TupleSerializer(Class<T> tupleClass, TypeSerializer<?>[] fieldSerializers) {
        super(tupleClass, fieldSerializers);
    }

    @Override
    public TupleSerializer<T> duplicate() {
        boolean stateful = false;
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
            if (duplicateFieldSerializers[i] == this.fieldSerializers[i]) continue;
            stateful = true;
        }
        if (stateful) {
            return new TupleSerializer<T>(this.tupleClass, duplicateFieldSerializers);
        }
        return this;
    }

    @Override
    public T createInstance() {
        try {
            Object t = this.instantiateRaw();
            for (int i = 0; i < this.arity; ++i) {
                ((Tuple)t).setField(this.fieldSerializers[i].createInstance(), i);
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate tuple.", e);
        }
    }

    @Override
    public T createInstance(Object[] fields) {
        try {
            Object t = this.instantiateRaw();
            for (int i = 0; i < this.arity; ++i) {
                ((Tuple)t).setField((Object)fields[i], i);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate tuple.", e);
        }
    }

    @Override
    public T createOrReuseInstance(Object[] fields, T reuse) {
        for (int i = 0; i < this.arity; ++i) {
            ((Tuple)reuse).setField((Object)fields[i], i);
        }
        return (T)reuse;
    }

    @Override
    public T copy(T from) {
        if (from == null) {
            return null;
        }
        Object target = this.instantiateRaw();
        for (int i = 0; i < this.arity; ++i) {
            Object copy = this.fieldSerializers[i].copy(((Tuple)from).getField(i));
            ((Tuple)target).setField(copy, i);
        }
        return target;
    }

    @Override
    public T copy(T from, T reuse) {
        if (from == null) {
            return null;
        }
        for (int i = 0; i < this.arity; ++i) {
            Object copy = this.fieldSerializers[i].copy(((Tuple)from).getField(i), ((Tuple)reuse).getField(i));
            ((Tuple)reuse).setField(copy, i);
        }
        return reuse;
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            Object o = ((Tuple)value).getField(i);
            try {
                this.fieldSerializers[i].serialize(o, target);
                continue;
            }
            catch (NullPointerException npex) {
                throw new NullFieldException(i, (Throwable)npex);
            }
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        Object tuple = this.instantiateRaw();
        for (int i = 0; i < this.arity; ++i) {
            Object field = this.fieldSerializers[i].deserialize(source);
            ((Tuple)tuple).setField(field, i);
        }
        return tuple;
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            Object field = this.fieldSerializers[i].deserialize(((Tuple)reuse).getField(i), source);
            ((Tuple)reuse).setField(field, i);
        }
        return reuse;
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new TupleSerializerSnapshot(this);
    }

    private T instantiateRaw() {
        try {
            if (this.constructor == null) {
                this.constructor = this.tupleClass.getDeclaredConstructor(new Class[0]);
                this.constructor.setAccessible(true);
            }
            return (T)((Tuple)this.constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate tuple.", e);
        }
    }
}

