/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkOutputMultiplexer;

@Internal
final class CombinedWatermarkStatus {
    private final List<PartialWatermark> partialWatermarks = new ArrayList<PartialWatermark>();
    private long combinedWatermark = Long.MIN_VALUE;
    private boolean idle = false;

    CombinedWatermarkStatus() {
    }

    public long getCombinedWatermark() {
        return this.combinedWatermark;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public boolean remove(PartialWatermark o) {
        return this.partialWatermarks.remove(o);
    }

    public void add(PartialWatermark element) {
        this.partialWatermarks.add(element);
    }

    public boolean updateCombinedWatermark() {
        if (this.partialWatermarks.isEmpty()) {
            return false;
        }
        long maximumOverAllOutputs = Long.MIN_VALUE;
        long minimumOverAllActiveOutputs = Long.MAX_VALUE;
        boolean allIdle = true;
        for (PartialWatermark partialWatermark : this.partialWatermarks) {
            long watermark = partialWatermark.getWatermark();
            maximumOverAllOutputs = Math.max(maximumOverAllOutputs, watermark);
            if (partialWatermark.isIdle()) continue;
            minimumOverAllActiveOutputs = Math.min(minimumOverAllActiveOutputs, watermark);
            allIdle = false;
        }
        this.idle = allIdle;
        long combinedWatermark = allIdle ? maximumOverAllOutputs : minimumOverAllActiveOutputs;
        if (combinedWatermark > this.combinedWatermark) {
            this.combinedWatermark = combinedWatermark;
            return true;
        }
        return false;
    }

    static class PartialWatermark {
        private long watermark = Long.MIN_VALUE;
        private boolean idle = false;
        private final WatermarkOutputMultiplexer.WatermarkUpdateListener onWatermarkUpdate;

        public PartialWatermark(WatermarkOutputMultiplexer.WatermarkUpdateListener onWatermarkUpdate) {
            this.onWatermarkUpdate = onWatermarkUpdate;
        }

        private long getWatermark() {
            return this.watermark;
        }

        public boolean setWatermark(long watermark) {
            boolean updated;
            this.setIdle(false);
            boolean bl = updated = watermark > this.watermark;
            if (updated) {
                this.onWatermarkUpdate.onWatermarkUpdate(watermark);
                this.watermark = Math.max(watermark, this.watermark);
            }
            return updated;
        }

        private boolean isIdle() {
            return this.idle;
        }

        public void setIdle(boolean idle) {
            this.idle = idle;
            this.onWatermarkUpdate.onIdleUpdate(idle);
        }
    }
}

