/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.application;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.SqlParserEOFException;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.service.application.Printer;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.table.gateway.service.operation.OperationExecutor;
import org.apache.flink.table.gateway.service.result.ResultFetcher;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class ScriptExecutor {
    final SessionContext context;
    final Printer printer;

    private ScriptExecutor(SessionContext context) {
        this(context, new Printer());
    }

    public ScriptExecutor(SessionContext context, Printer printer) {
        this.context = context;
        this.printer = printer;
    }

    public static ScriptExecutor of(SessionContext context) {
        return new ScriptExecutor(context);
    }

    public void execute(String script) {
        ResultIterator iterator = new ResultIterator(script);
        try {
            while (iterator.hasNext()) {
                Result result = iterator.next();
                this.printer.print(result.statement);
                if (result.error != null) {
                    throw result.error;
                }
                this.printer.print(Preconditions.checkNotNull(result.fetcher));
            }
        }
        catch (Throwable t) {
            this.printer.print(t);
            throw new SqlGatewayException("Failed to execute the script.", t);
        }
    }

    static enum State {
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        BACK_QUOTE,
        SINGLE_COMMENT,
        MULTI_LINE_COMMENT,
        NORMAL;

    }

    static class Result {
        final String statement;
        @Nullable
        final ResultFetcher fetcher;
        @Nullable
        final Throwable error;

        public Result(String statement, ResultFetcher fetcher) {
            this(statement, fetcher, null);
        }

        public Result(String statement, Throwable error) {
            this(statement, null, error);
        }

        private Result(String statement, @Nullable ResultFetcher fetcher, @Nullable Throwable error) {
            this.statement = statement;
            this.fetcher = fetcher;
            this.error = error;
        }
    }

    class ResultIterator
    implements Iterator<Result> {
        StringBuilder previousPaddingSqlBuilder = new StringBuilder();
        StringBuilder currentPaddingSqlBuilder = new StringBuilder();
        StringBuilder currentPaddingLineBuilder = new StringBuilder();
        private final String script;
        private int position;
        private String statement;
        private Throwable throwable;
        private OperationExecutor executor;

        public ResultIterator(String script) {
            this.script = script;
            this.position = 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            State state = State.NORMAL;
            StringBuilder currentSqlBuilder = new StringBuilder();
            char currentChar = '\u0000';
            boolean hasNext = false;
            this.executor = new OperationExecutor(ScriptExecutor.this.context, (config, classloader) -> StreamExecutionEnvironment.getExecutionEnvironment(config));
            block13: for (int i = this.position; i < this.script.length(); ++i) {
                char lastChar = currentChar;
                currentChar = this.script.charAt(i);
                currentSqlBuilder.append(currentChar);
                this.currentPaddingLineBuilder.append(" ");
                switch (currentChar) {
                    case '\'': {
                        if (state == State.SINGLE_QUOTE) {
                            state = State.NORMAL;
                            break;
                        }
                        if (state != State.NORMAL) break;
                        state = State.SINGLE_QUOTE;
                        break;
                    }
                    case '\"': {
                        if (state == State.DOUBLE_QUOTE) {
                            state = State.NORMAL;
                            break;
                        }
                        if (state != State.NORMAL) break;
                        state = State.DOUBLE_QUOTE;
                        break;
                    }
                    case '`': {
                        if (state == State.BACK_QUOTE) {
                            state = State.NORMAL;
                            break;
                        }
                        if (state != State.NORMAL) break;
                        state = State.BACK_QUOTE;
                        break;
                    }
                    case '-': {
                        if (lastChar != '-' || state != State.NORMAL) break;
                        state = State.SINGLE_COMMENT;
                        break;
                    }
                    case '\n': {
                        if (state == State.SINGLE_COMMENT) {
                            state = State.NORMAL;
                        }
                        this.currentPaddingLineBuilder.setLength(0);
                        this.currentPaddingSqlBuilder.append("\n");
                        break;
                    }
                    case '*': {
                        if (lastChar != '/' || state != State.NORMAL) break;
                        state = State.MULTI_LINE_COMMENT;
                        break;
                    }
                    case '/': {
                        if (lastChar != '*' || state != State.MULTI_LINE_COMMENT) break;
                        state = State.NORMAL;
                        break;
                    }
                    case ';': {
                        if (state != State.NORMAL) break;
                        i = this.prefetch(i + 1, currentSqlBuilder, this.currentPaddingSqlBuilder, this.currentPaddingLineBuilder);
                        this.statement = currentSqlBuilder.toString();
                        try {
                            this.position = i + 1;
                            this.parse(String.valueOf(this.previousPaddingSqlBuilder) + this.statement);
                        }
                        catch (SqlParserEOFException e) {
                            if (i != this.script.length() - 1) continue block13;
                            this.throwable = e;
                        }
                        catch (Throwable t) {
                            this.throwable = t;
                        }
                        hasNext = true;
                        this.previousPaddingSqlBuilder.append((CharSequence)this.currentPaddingSqlBuilder);
                        this.previousPaddingSqlBuilder.append((CharSequence)this.currentPaddingLineBuilder);
                        this.currentPaddingSqlBuilder.setLength(0);
                        this.currentPaddingLineBuilder.setLength(0);
                    }
                }
                if (!hasNext) continue;
                return true;
            }
            this.position = this.script.length();
            this.statement = currentSqlBuilder.toString();
            if (!StringUtils.isNullOrWhitespaceOnly(this.statement)) {
                this.parse(String.valueOf(this.previousPaddingSqlBuilder) + this.statement);
                return true;
            }
            return false;
        }

        @Override
        public Result next() {
            if (this.throwable != null) {
                Throwable t = this.throwable;
                this.throwable = null;
                return new Result(this.statement, t);
            }
            try {
                return new Result(this.statement, this.executor.executeStatement(OperationHandle.create(), this.statement));
            }
            catch (Throwable t) {
                return new Result(this.statement, t);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private int prefetch(int begin, StringBuilder currentSqlBuilder, StringBuilder currentPaddingSqlBuilder, StringBuilder currentPaddingLineBuilder) {
            State state = State.NORMAL;
            int i = begin;
            while (true) {
                block11: {
                    if (i >= this.script.length()) {
                        return this.script.length() - 1;
                    }
                    char currentChar = this.script.charAt(i);
                    char nextChar = i + 1 < this.script.length() ? this.script.charAt(i + 1) : currentChar;
                    switch (currentChar) {
                        case '-': {
                            if (nextChar != '-' || state != State.NORMAL) break;
                            state = State.SINGLE_COMMENT;
                            break;
                        }
                        case '\n': {
                            if (state != State.SINGLE_COMMENT) break;
                            state = State.NORMAL;
                            break;
                        }
                        case '*': {
                            if (nextChar != '/' || state != State.MULTI_LINE_COMMENT) break;
                            state = State.NORMAL;
                            currentSqlBuilder.append("*/");
                            currentPaddingLineBuilder.append("  ");
                            ++i;
                            break block11;
                        }
                        case '/': {
                            if (nextChar != '*' || state != State.NORMAL) break;
                            state = State.MULTI_LINE_COMMENT;
                        }
                    }
                    if (state == State.NORMAL && currentChar != ';' && !Character.isWhitespace(currentChar)) {
                        return i - 1;
                    }
                    currentSqlBuilder.append(currentChar);
                    if (currentChar == '\n') {
                        currentPaddingLineBuilder.setLength(0);
                        currentPaddingSqlBuilder.append("\n");
                    } else {
                        currentPaddingLineBuilder.append(" ");
                    }
                }
                ++i;
            }
        }

        private void parse(String statement) {
            List<Operation> operations = this.executor.getTableEnvironment().getParser().parse(statement);
            if (operations.size() != 1) {
                throw new SqlGatewayException("Unsupported SQL query! Something unexpected happens. Please report an issue to the Flink Community.");
            }
        }
    }
}

