/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import java.util.HashSet;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.runtime.io.checkpointing.UpstreamRecoveryTracker;
import org.apache.flink.util.Preconditions;

final class UpstreamRecoveryTrackerImpl
implements UpstreamRecoveryTracker {
    private final HashSet<InputChannelInfo> restoredChannels = new HashSet();
    private int numUnrestoredChannels;
    private final InputGate inputGate;

    UpstreamRecoveryTrackerImpl(InputGate inputGate) {
        this.numUnrestoredChannels = inputGate.getNumberOfInputChannels();
        this.inputGate = inputGate;
    }

    @Override
    public void handleEndOfRecovery(InputChannelInfo channelInfo) throws IOException {
        if (this.numUnrestoredChannels > 0) {
            Preconditions.checkState(!this.restoredChannels.contains(channelInfo), "already restored: %s", channelInfo);
            this.restoredChannels.add(channelInfo);
            --this.numUnrestoredChannels;
            if (this.numUnrestoredChannels == 0) {
                for (InputChannelInfo inputChannelInfo : this.inputGate.getChannelInfos()) {
                    this.inputGate.resumeConsumption(inputChannelInfo);
                }
                this.restoredChannels.clear();
            }
        }
    }

    @Override
    public boolean allChannelsRecovered() {
        return this.numUnrestoredChannels == 0;
    }
}

