/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.representer;

import java.util.Date;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.DumperOptions;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.nodes.Node;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.nodes.Tag;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.representer.Represent;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.representer.Representer;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.representer.SafeRepresenter;

public class JsonRepresenter
extends Representer {
    public JsonRepresenter(DumperOptions options) {
        super(options);
        this.representers.put(byte[].class, new RepresentByteArray());
        this.multiRepresenters.put(Date.class, new RepresentDate());
        if (options.getDefaultScalarStyle() != DumperOptions.ScalarStyle.JSON_SCALAR_STYLE) {
            throw new IllegalStateException("JSON requires ScalarStyle.JSON_SCALAR_STYLE");
        }
        if (options.getNonPrintableStyle() != DumperOptions.NonPrintableStyle.ESCAPE) {
            throw new IllegalStateException("JSON requires NonPrintableStyle.ESCAPE");
        }
    }

    protected class RepresentByteArray
    implements Represent {
        protected RepresentByteArray() {
        }

        @Override
        public Node representData(Object data) {
            char[] binary = Base64Coder.encode((byte[])data);
            return JsonRepresenter.this.representScalar(Tag.STR, String.valueOf(binary));
        }
    }

    protected class RepresentDate
    extends SafeRepresenter.RepresentDate {
        protected RepresentDate() {
            super(JsonRepresenter.this);
        }

        @Override
        public Tag getDefaultTag() {
            return Tag.STR;
        }
    }
}

