/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.metrics.StateMetricBase;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;

class AbstractMetricsTrackState<K, N, V, S extends InternalKvState<K, N, V>, LSM extends StateMetricBase>
implements InternalKvState<K, N, V> {
    protected S original;
    protected LSM latencyTrackingStateMetric;
    protected LSM sizeTrackingStateMetric;
    protected KeyedStateBackend<K> keyedStateBackend;
    protected N currentNamespace;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<N> namespaceSerializer;
    protected final TypeSerializer<V> valueSerializer;
    protected final DataOutputSerializer outputSerializer;
    protected long namespaceSize;
    protected long keySize;
    protected long valueSize;

    AbstractMetricsTrackState(S original, KeyedStateBackend<K> keyedStateBackend, LSM latencyTrackingStateMetric, LSM sizeTrackingStateMetric) {
        this.original = original;
        this.keyedStateBackend = keyedStateBackend;
        this.latencyTrackingStateMetric = latencyTrackingStateMetric;
        this.sizeTrackingStateMetric = sizeTrackingStateMetric;
        this.keySerializer = this.getKeySerializer() != null ? this.getKeySerializer().duplicate() : null;
        this.namespaceSerializer = this.getNamespaceSerializer() != null ? this.getNamespaceSerializer().duplicate() : null;
        this.valueSerializer = this.getValueSerializer() != null ? this.getValueSerializer().duplicate() : null;
        this.outputSerializer = new DataOutputSerializer(64);
        this.initStateSize();
    }

    private void initStateSize() {
        if (this.keySerializer != null) {
            this.keySize = this.keySerializer.getLength();
        }
        if (this.valueSerializer != null) {
            this.valueSize = this.valueSerializer.getLength();
        }
        if (this.namespaceSerializer != null) {
            this.namespaceSize = this.namespaceSerializer.getLength();
        }
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.original.getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.original.getNamespaceSerializer();
    }

    @Override
    public TypeSerializer<V> getValueSerializer() {
        return this.original.getValueSerializer();
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.original.setCurrentNamespace(namespace);
        this.currentNamespace = namespace;
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        return this.original.getSerializedValue(serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer, safeValueSerializer);
    }

    @Override
    public InternalKvState.StateIncrementalVisitor<K, N, V> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        return this.original.getStateIncrementalVisitor(recommendedMaxNumberOfReturnedRecords);
    }

    @Override
    public void clear() {
        if (this.latencyTrackingStateMetric != null && ((StateMetricBase)this.latencyTrackingStateMetric).trackMetricsOnClear()) {
            this.trackLatency(() -> this.original.clear(), "stateClearLatency");
        } else {
            this.original.clear();
        }
    }

    protected <T> T trackLatency(Supplier<T> supplier, String latencyLabel) {
        long startTime = System.nanoTime();
        T result = supplier.get();
        long latency = System.nanoTime() - startTime;
        ((StateMetricBase)this.latencyTrackingStateMetric).updateMetrics(latencyLabel, latency);
        return result;
    }

    protected <T> T trackLatencyWithIOException(SupplierWithException<T, IOException> supplier, String latencyLabel) throws IOException {
        long startTime = System.nanoTime();
        T result = supplier.get();
        long latency = System.nanoTime() - startTime;
        ((StateMetricBase)this.latencyTrackingStateMetric).updateMetrics(latencyLabel, latency);
        return result;
    }

    protected void trackLatencyWithIOException(ThrowingRunnable<IOException> runnable, String latencyLabel) throws IOException {
        long startTime = System.nanoTime();
        runnable.run();
        long latency = System.nanoTime() - startTime;
        ((StateMetricBase)this.latencyTrackingStateMetric).updateMetrics(latencyLabel, latency);
    }

    protected <T> T trackLatencyWithException(SupplierWithException<T, Exception> supplier, String latencyLabel) throws Exception {
        long startTime = System.nanoTime();
        T result = supplier.get();
        long latency = System.nanoTime() - startTime;
        ((StateMetricBase)this.latencyTrackingStateMetric).updateMetrics(latencyLabel, latency);
        return result;
    }

    protected void trackLatencyWithException(ThrowingRunnable<Exception> runnable, String latencyLabel) throws Exception {
        long startTime = System.nanoTime();
        runnable.run();
        long latency = System.nanoTime() - startTime;
        ((StateMetricBase)this.latencyTrackingStateMetric).updateMetrics(latencyLabel, latency);
    }

    protected void trackLatency(Runnable runnable, String latencyLabel) {
        long startTime = System.nanoTime();
        runnable.run();
        long latency = System.nanoTime() - startTime;
        ((StateMetricBase)this.latencyTrackingStateMetric).updateMetrics(latencyLabel, latency);
    }

    protected K getCurrentKey() {
        return this.keyedStateBackend.getCurrentKey();
    }

    public final N getCurrentNamespace() {
        return this.currentNamespace;
    }

    protected long sizeOfKey() throws IOException {
        if (this.keySerializer != null && this.keySerializer.getLength() == -1) {
            try {
                this.keySerializer.serialize(this.keyedStateBackend.getCurrentKey(), this.outputSerializer);
                this.keySize = this.outputSerializer.length();
            }
            finally {
                this.outputSerializer.clear();
            }
        }
        if (this.namespaceSerializer != null && this.namespaceSerializer.getLength() == -1) {
            try {
                this.namespaceSerializer.serialize(this.getCurrentNamespace(), this.outputSerializer);
                this.namespaceSize = this.outputSerializer.length();
            }
            finally {
                this.outputSerializer.clear();
            }
        }
        return this.keySize + this.namespaceSize;
    }

    protected long sizeOfValue(V value) throws IOException {
        if (this.valueSerializer == null || value == null) {
            this.valueSize = 0L;
        } else if (this.valueSerializer.getLength() == -1) {
            try {
                this.valueSerializer.serialize(value, this.outputSerializer);
                this.valueSize = this.outputSerializer.length();
            }
            finally {
                this.outputSerializer.clear();
            }
        }
        return this.valueSize;
    }

    @VisibleForTesting
    LSM getLatencyTrackingStateMetric() {
        return this.latencyTrackingStateMetric;
    }

    @VisibleForTesting
    LSM getSizeTrackingStateMetric() {
        return this.sizeTrackingStateMetric;
    }
}

