/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.CommitterInitContext;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.TransformationWithLineage;
import org.apache.flink.util.function.SerializableFunction;
import org.apache.flink.util.function.SerializableSupplier;

@Internal
public class GlobalCommitterTransform<CommT>
extends TransformationWithLineage<Void> {
    private final DataStream<CommittableMessage<CommT>> inputStream;
    private final SerializableFunction<CommitterInitContext, Committer<CommT>> committerFactory;
    private final SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializer;

    public GlobalCommitterTransform(DataStream<CommittableMessage<CommT>> inputStream, SerializableFunction<CommitterInitContext, Committer<CommT>> committerFactory, SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializer) {
        super("Global Committer", Types.VOID, 1, true);
        this.inputStream = inputStream;
        this.committerFactory = committerFactory;
        this.committableSerializer = committableSerializer;
    }

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
    }

    @Override
    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        ArrayList<Transformation<?>> result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.inputStream.getTransformation().getTransitivePredecessors());
        return result;
    }

    @Override
    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.inputStream.getTransformation());
    }

    public DataStream<CommittableMessage<CommT>> getInputStream() {
        return this.inputStream;
    }

    public SerializableFunction<CommitterInitContext, Committer<CommT>> getCommitterFactory() {
        return this.committerFactory;
    }

    public SerializableSupplier<SimpleVersionedSerializer<CommT>> getCommittableSerializer() {
        return this.committableSerializer;
    }
}

