/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.windowing.PassThroughWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperatorBuilder;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Public
public class WindowedStream<T, K, W extends Window> {
    private final KeyedStream<T, K> input;
    private final WindowOperatorBuilder<T, K, W> builder;
    private boolean isEnableAsyncState;

    @PublicEvolving
    public WindowedStream(KeyedStream<T, K> input, WindowAssigner<? super T, W> windowAssigner) {
        this.input = input;
        this.isEnableAsyncState = input.isEnableAsyncState();
        this.builder = new WindowOperatorBuilder<T, K, W>(windowAssigner, windowAssigner.getDefaultTrigger(), input.getExecutionConfig(), input.getType(), input.getKeySelector(), input.getKeyType());
    }

    @PublicEvolving
    public WindowedStream<T, K, W> trigger(Trigger<? super T, ? super W> trigger) {
        this.builder.trigger(trigger);
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> allowedLateness(Duration lateness) {
        this.builder.allowedLateness(lateness);
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> sideOutputLateData(OutputTag<T> outputTag) {
        outputTag = this.input.getExecutionEnvironment().clean(outputTag);
        this.builder.sideOutputLateData(outputTag);
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.builder.evictor(evictor);
        return this;
    }

    public SingleOutputStreamOperator<T> reduce(ReduceFunction<T> function) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction. Please use reduce(ReduceFunction, WindowFunction) instead.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        return this.reduce(function, new PassThroughWindowFunction());
    }

    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function) {
        TypeInformation inType = this.input.getType();
        TypeInformation<R> resultType = WindowedStream.getWindowFunctionReturnType(function, inType);
        return this.reduce(reduceFunction, function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        reduceFunction = this.input.getExecutionEnvironment().clean(reduceFunction);
        String opName = this.builder.generateOperatorName();
        String opDescription = this.builder.generateOperatorDescription(reduceFunction, function);
        OneInputStreamOperator<T, R> operator = this.isEnableAsyncState ? this.builder.asyncReduce(reduceFunction, function) : this.builder.reduce(reduceFunction, function);
        return this.input.transform(opName, resultType, operator).setDescription(opDescription);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, ProcessWindowFunction<T, R, K, W> function) {
        TypeInformation<R> resultType = WindowedStream.getProcessWindowFunctionReturnType(function, this.input.getType(), null);
        return this.reduce(reduceFunction, function, resultType);
    }

    @Internal
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, ProcessWindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        reduceFunction = this.input.getExecutionEnvironment().clean(reduceFunction);
        String opName = this.builder.generateOperatorName();
        String opDescription = this.builder.generateOperatorDescription(reduceFunction, function);
        OneInputStreamOperator<T, R> operator = this.isEnableAsyncState ? this.builder.asyncReduce(reduceFunction, function) : this.builder.reduce(reduceFunction, function);
        return this.input.transform(opName, resultType, operator).setDescription(opDescription);
    }

    @PublicEvolving
    public <ACC, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, R> function) {
        Preconditions.checkNotNull(function, "function");
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregation function cannot be a RichFunction.");
        }
        TypeInformation<ACC> accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(function, this.input.getType(), null, false);
        TypeInformation<R> resultType = TypeExtractor.getAggregateFunctionReturnType(function, this.input.getType(), null, false);
        return this.aggregate(function, accumulatorType, resultType);
    }

    @PublicEvolving
    public <ACC, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, R> function, TypeInformation<ACC> accumulatorType, TypeInformation<R> resultType) {
        Preconditions.checkNotNull(function, "function");
        Preconditions.checkNotNull(accumulatorType, "accumulatorType");
        Preconditions.checkNotNull(resultType, "resultType");
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregation function cannot be a RichFunction.");
        }
        return this.aggregate(function, new PassThroughWindowFunction(), accumulatorType, resultType);
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggFunction, WindowFunction<V, R, K, W> windowFunction) {
        Preconditions.checkNotNull(aggFunction, "aggFunction");
        Preconditions.checkNotNull(windowFunction, "windowFunction");
        TypeInformation<ACC> accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(aggFunction, this.input.getType(), null, false);
        TypeInformation<V> aggResultType = TypeExtractor.getAggregateFunctionReturnType(aggFunction, this.input.getType(), null, false);
        TypeInformation<R> resultType = WindowedStream.getWindowFunctionReturnType(windowFunction, aggResultType);
        return this.aggregate(aggFunction, windowFunction, accumulatorType, resultType);
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, WindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType, TypeInformation<R> resultType) {
        Preconditions.checkNotNull(aggregateFunction, "aggregateFunction");
        Preconditions.checkNotNull(windowFunction, "windowFunction");
        Preconditions.checkNotNull(accumulatorType, "accumulatorType");
        Preconditions.checkNotNull(resultType, "resultType");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        windowFunction = this.input.getExecutionEnvironment().clean(windowFunction);
        aggregateFunction = this.input.getExecutionEnvironment().clean(aggregateFunction);
        String opName = this.builder.generateOperatorName();
        String opDescription = this.builder.generateOperatorDescription(aggregateFunction, windowFunction);
        OneInputStreamOperator<T, R> operator = this.isEnableAsyncState ? this.builder.asyncAggregate(aggregateFunction, windowFunction, accumulatorType) : this.builder.aggregate(aggregateFunction, windowFunction, accumulatorType);
        return this.input.transform(opName, resultType, operator).setDescription(opDescription);
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggFunction, ProcessWindowFunction<V, R, K, W> windowFunction) {
        Preconditions.checkNotNull(aggFunction, "aggFunction");
        Preconditions.checkNotNull(windowFunction, "windowFunction");
        TypeInformation<ACC> accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(aggFunction, this.input.getType(), null, false);
        TypeInformation<V> aggResultType = TypeExtractor.getAggregateFunctionReturnType(aggFunction, this.input.getType(), null, false);
        TypeInformation<R> resultType = WindowedStream.getProcessWindowFunctionReturnType(windowFunction, aggResultType, null);
        return this.aggregate(aggFunction, windowFunction, accumulatorType, aggResultType, resultType);
    }

    private static <IN, OUT, KEY> TypeInformation<OUT> getWindowFunctionReturnType(WindowFunction<IN, OUT, KEY, ?> function, TypeInformation<IN> inType) {
        return TypeExtractor.getUnaryOperatorReturnType(function, WindowFunction.class, 0, 1, new int[]{3, 0}, inType, null, true);
    }

    private static <IN, OUT, KEY> TypeInformation<OUT> getProcessWindowFunctionReturnType(ProcessWindowFunction<IN, OUT, KEY, ?> function, TypeInformation<IN> inType, String functionName) {
        return TypeExtractor.getUnaryOperatorReturnType(function, ProcessWindowFunction.class, 0, 1, TypeExtractor.NO_INDEX, inType, functionName, true);
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, ProcessWindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType, TypeInformation<V> aggregateResultType, TypeInformation<R> resultType) {
        Preconditions.checkNotNull(aggregateFunction, "aggregateFunction");
        Preconditions.checkNotNull(windowFunction, "windowFunction");
        Preconditions.checkNotNull(accumulatorType, "accumulatorType");
        Preconditions.checkNotNull(aggregateResultType, "aggregateResultType");
        Preconditions.checkNotNull(resultType, "resultType");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        windowFunction = this.input.getExecutionEnvironment().clean(windowFunction);
        aggregateFunction = this.input.getExecutionEnvironment().clean(aggregateFunction);
        String opName = this.builder.generateOperatorName();
        String opDescription = this.builder.generateOperatorDescription(aggregateFunction, windowFunction);
        OneInputStreamOperator<T, R> operator = this.isEnableAsyncState ? this.builder.asyncAggregate(aggregateFunction, windowFunction, accumulatorType) : this.builder.aggregate(aggregateFunction, windowFunction, accumulatorType);
        return this.input.transform(opName, resultType, operator).setDescription(opDescription);
    }

    public <R> SingleOutputStreamOperator<R> apply(WindowFunction<T, R, K, W> function) {
        TypeInformation<R> resultType = WindowedStream.getWindowFunctionReturnType(function, this.getInputType());
        return this.apply(function, resultType);
    }

    public <R> SingleOutputStreamOperator<R> apply(WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        String opName = this.builder.generateOperatorName();
        String opDescription = this.builder.generateOperatorDescription(function, null);
        OneInputStreamOperator<T, R> operator = this.isEnableAsyncState ? this.builder.asyncApply(function) : this.builder.apply(function);
        return this.input.transform(opName, resultType, operator).setDescription(opDescription);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> process(ProcessWindowFunction<T, R, K, W> function) {
        TypeInformation<R> resultType = WindowedStream.getProcessWindowFunctionReturnType(function, this.getInputType(), null);
        return this.process(function, resultType);
    }

    @Internal
    public <R> SingleOutputStreamOperator<R> process(ProcessWindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        String opName = this.builder.generateOperatorName();
        String opDesc = this.builder.generateOperatorDescription(function, null);
        OneInputStreamOperator<T, R> operator = this.isEnableAsyncState ? this.builder.asyncProcess(function) : this.builder.process(function);
        return this.input.transform(opName, resultType, operator).setDescription(opDesc);
    }

    public SingleOutputStreamOperator<T> sum(int positionToSum) {
        return this.aggregate(new SumAggregator(positionToSum, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> sum(String field) {
        return this.aggregate(new SumAggregator(field, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(int positionToMin) {
        return this.aggregate(new ComparableAggregator(positionToMin, this.input.getType(), AggregationFunction.AggregationType.MIN, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MIN, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T> minBy(String field) {
        return this.minBy(field, true);
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMinBy, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(int positionToMax) {
        return this.aggregate(new ComparableAggregator(positionToMax, this.input.getType(), AggregationFunction.AggregationType.MAX, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAX, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T> maxBy(String field) {
        return this.maxBy(field, true);
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMaxBy, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    private SingleOutputStreamOperator<T> aggregate(AggregationFunction<T> aggregator) {
        return this.reduce(aggregator);
    }

    @Experimental
    public WindowedStream<T, K, W> enableAsyncState() {
        this.input.enableAsyncState();
        this.isEnableAsyncState = true;
        return this;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.input.getExecutionEnvironment();
    }

    public TypeInformation<T> getInputType() {
        return this.input.getType();
    }

    @VisibleForTesting
    long getAllowedLateness() {
        return this.builder.getAllowedLateness();
    }
}

