/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.compression.AirCompressorFactory;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.compression.Lz4BlockCompressionFactory;
import org.apache.flink.shaded.io.airlift.compress.lzo.LzoCompressor;
import org.apache.flink.shaded.io.airlift.compress.lzo.LzoDecompressor;
import org.apache.flink.shaded.io.airlift.compress.zstd.ZstdCompressor;
import org.apache.flink.shaded.io.airlift.compress.zstd.ZstdDecompressor;
import org.apache.flink.util.Preconditions;

public interface BlockCompressionFactory {
    public BlockCompressor getCompressor();

    public BlockDecompressor getDecompressor();

    public static BlockCompressionFactory createBlockCompressionFactory(NettyShuffleEnvironmentOptions.CompressionCodec compressionName) {
        BlockCompressionFactory blockCompressionFactory;
        Preconditions.checkNotNull(compressionName);
        switch (compressionName) {
            case LZ4: {
                blockCompressionFactory = new Lz4BlockCompressionFactory();
                break;
            }
            case LZO: {
                blockCompressionFactory = new AirCompressorFactory(new LzoCompressor(), new LzoDecompressor());
                break;
            }
            case ZSTD: {
                blockCompressionFactory = new AirCompressorFactory(new ZstdCompressor(), new ZstdDecompressor());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown CompressionMethod " + compressionName);
            }
        }
        return blockCompressionFactory;
    }
}

