/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.execution;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;

@Internal
public final class DetachedJobExecutionResult
extends JobExecutionResult {
    public static final String DETACHED_MESSAGE = "Job was submitted in detached mode. ";
    public static final String EAGER_FUNCTION_MESSAGE = "Please make sure your program doesn't call an eager execution function [collect, print, printToErr, count]. ";
    public static final String JOB_RESULT_MESSAGE = "Results of job execution, such as accumulators, runtime, etc. are not available. ";

    public DetachedJobExecutionResult(JobID jobID) {
        super(jobID, -1L, null);
    }

    @Override
    public long getNetRuntime() {
        throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, etc. are not available. ");
    }

    @Override
    public <T> T getAccumulatorResult(String accumulatorName) {
        throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, etc. are not available. Please make sure your program doesn't call an eager execution function [collect, print, printToErr, count]. ");
    }

    @Override
    public Map<String, Object> getAllAccumulatorResults() {
        throw new InvalidProgramException("Job was submitted in detached mode. Results of job execution, such as accumulators, runtime, etc. are not available. ");
    }

    @Override
    public JobID getJobID() {
        return super.getJobID();
    }

    @Override
    public boolean isJobExecutionResult() {
        return false;
    }

    @Override
    public JobExecutionResult getJobExecutionResult() {
        return this;
    }

    @Override
    public String toString() {
        return "Job has been submitted with JobID " + this.getJobID();
    }
}

