/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class MultisetTypeInfo<T>
extends MapTypeInfo<T, Integer> {
    private static final long serialVersionUID = 1L;

    public MultisetTypeInfo(Class<T> elementTypeClass) {
        super(elementTypeClass, Integer.class);
    }

    public MultisetTypeInfo(TypeInformation<T> elementTypeInfo) {
        super(elementTypeInfo, BasicTypeInfo.INT_TYPE_INFO);
    }

    public TypeInformation<T> getElementTypeInfo() {
        return this.getKeyTypeInfo();
    }

    @Override
    public String toString() {
        return "Multiset<" + this.getKeyTypeInfo() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultisetTypeInfo) {
            MultisetTypeInfo other = (MultisetTypeInfo)obj;
            return other.canEqual(this) && this.getKeyTypeInfo().equals(other.getKeyTypeInfo());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.getKeyTypeInfo().hashCode() + 1;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    @PublicEvolving
    public static <C> MultisetTypeInfo<C> getInfoFor(TypeInformation<C> componentInfo) {
        Preconditions.checkNotNull(componentInfo);
        return new MultisetTypeInfo<C>(componentInfo);
    }
}

