/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.DoubleComparator;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;

@Internal
public class DoublePrimitiveArrayComparator
extends PrimitiveArrayComparator<double[], DoubleComparator> {
    public DoublePrimitiveArrayComparator(boolean ascending) {
        super(ascending, new DoubleComparator(ascending));
    }

    @Override
    public int hash(double[] record) {
        int result = 0;
        for (double field : record) {
            long bits = Double.doubleToLongBits(field);
            result += (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    @Override
    public int compare(double[] first, double[] second) {
        for (int x = 0; x < Math.min(first.length, second.length); ++x) {
            int cmp = Double.compare(first[x], second[x]);
            if (cmp == 0) continue;
            return this.ascending ? cmp : -cmp;
        }
        int cmp = first.length - second.length;
        return this.ascending ? cmp : -cmp;
    }

    @Override
    public TypeComparator<double[]> duplicate() {
        DoublePrimitiveArrayComparator dupe = new DoublePrimitiveArrayComparator(this.ascending);
        dupe.setReference((double[])this.reference);
        return dupe;
    }
}

