/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.CheckpointableInputFormat;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.OptimizerOptions;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class DelimitedInputFormat<OT>
extends FileInputFormat<OT>
implements CheckpointableInputFormat<FileInputSplit, Long> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DelimitedInputFormat.class);
    private String charsetName = "UTF-8";
    private transient Charset charset;
    private static final int DEFAULT_READ_BUFFER_SIZE = 0x100000;
    private static final int NUM_SAMPLES_UNDEFINED = -1;
    private static int DEFAULT_MAX_NUM_SAMPLES;
    private static int DEFAULT_MIN_NUM_SAMPLES;
    private static int MAX_SAMPLE_LEN;
    private transient byte[] readBuffer;
    private transient byte[] wrapBuffer;
    private transient int readPos;
    private transient int limit;
    protected transient byte[] currBuffer;
    protected transient int currOffset;
    protected transient int currLen;
    private transient boolean overLimit;
    private transient boolean end;
    private long offset = -1L;
    private byte[] delimiter = new byte[]{10};
    private String delimiterString = null;
    private int lineLengthLimit = Integer.MAX_VALUE;
    private int bufferSize = -1;
    private int numLineSamples = -1;
    protected static final String RECORD_DELIMITER = "delimited-format.delimiter";
    private static final String NUM_STATISTICS_SAMPLES = "delimited-format.numSamples";

    protected static void loadConfigParameters(Configuration parameters) {
        int maxSamples = parameters.get(OptimizerOptions.DELIMITED_FORMAT_MAX_LINE_SAMPLES);
        int minSamples = parameters.get(OptimizerOptions.DELIMITED_FORMAT_MIN_LINE_SAMPLES);
        if (maxSamples < 0) {
            LOG.error("Invalid default maximum number of line samples: " + maxSamples + ". Using default value of " + OptimizerOptions.DELIMITED_FORMAT_MAX_LINE_SAMPLES.key());
            maxSamples = OptimizerOptions.DELIMITED_FORMAT_MAX_LINE_SAMPLES.defaultValue();
        }
        if (minSamples < 0) {
            LOG.error("Invalid default minimum number of line samples: " + minSamples + ". Using default value of " + OptimizerOptions.DELIMITED_FORMAT_MIN_LINE_SAMPLES.key());
            minSamples = OptimizerOptions.DELIMITED_FORMAT_MIN_LINE_SAMPLES.defaultValue();
        }
        DEFAULT_MAX_NUM_SAMPLES = maxSamples;
        if (minSamples > maxSamples) {
            LOG.error("Default minimum number of line samples cannot be greater the default maximum number of line samples: min=" + minSamples + ", max=" + maxSamples + ". Defaulting minimum to maximum.");
            DEFAULT_MIN_NUM_SAMPLES = maxSamples;
        } else {
            DEFAULT_MIN_NUM_SAMPLES = minSamples;
        }
        int maxLen = parameters.get(OptimizerOptions.DELIMITED_FORMAT_MAX_SAMPLE_LEN);
        if (maxLen <= 0) {
            maxLen = OptimizerOptions.DELIMITED_FORMAT_MAX_SAMPLE_LEN.defaultValue();
            LOG.error("Invalid value for the maximum sample record length. Using default value of " + maxLen + ".");
        } else if (maxLen < 0x100000) {
            maxLen = 0x100000;
            LOG.warn("Increasing maximum sample record length to size of the read buffer (" + maxLen + ").");
        }
        MAX_SAMPLE_LEN = maxLen;
    }

    public DelimitedInputFormat() {
        this(null, null);
    }

    protected DelimitedInputFormat(Path filePath, Configuration configuration) {
        super(filePath);
        if (configuration == null) {
            configuration = GlobalConfiguration.loadConfiguration();
        }
        DelimitedInputFormat.loadConfigParameters(configuration);
    }

    @PublicEvolving
    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = Charset.forName(this.charsetName);
        }
        return this.charset;
    }

    @PublicEvolving
    public void setCharset(String charset) {
        this.charsetName = Preconditions.checkNotNull(charset);
        this.charset = null;
        if (this.delimiterString != null) {
            this.delimiter = this.delimiterString.getBytes(this.getCharset());
        }
    }

    public byte[] getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(byte[] delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null");
        }
        this.delimiter = delimiter;
        this.delimiterString = null;
    }

    public void setDelimiter(char delimiter) {
        this.setDelimiter(String.valueOf(delimiter));
    }

    public void setDelimiter(String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null");
        }
        this.delimiter = delimiter.getBytes(this.getCharset());
        this.delimiterString = delimiter;
    }

    public int getLineLengthLimit() {
        return this.lineLengthLimit;
    }

    public void setLineLengthLimit(int lineLengthLimit) {
        if (lineLengthLimit < 1) {
            throw new IllegalArgumentException("Line length limit must be at least 1.");
        }
        this.lineLengthLimit = lineLengthLimit;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 2) {
            throw new IllegalArgumentException("Buffer size must be at least 2.");
        }
        this.bufferSize = bufferSize;
    }

    public int getNumLineSamples() {
        return this.numLineSamples;
    }

    public void setNumLineSamples(int numLineSamples) {
        if (numLineSamples < 0) {
            throw new IllegalArgumentException("Number of line samples must not be negative.");
        }
        this.numLineSamples = numLineSamples;
    }

    public abstract OT readRecord(OT var1, byte[] var2, int var3, int var4) throws IOException;

    @Override
    public void configure(Configuration parameters) {
        String samplesString;
        String delimString;
        super.configure(parameters);
        if (Arrays.equals(this.delimiter, new byte[]{10}) && (delimString = parameters.getString(RECORD_DELIMITER, null)) != null) {
            this.setDelimiter(delimString);
        }
        if (this.numLineSamples == -1 && (samplesString = parameters.getString(NUM_STATISTICS_SAMPLES, null)) != null) {
            try {
                this.setNumLineSamples(Integer.parseInt(samplesString));
            }
            catch (NumberFormatException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid value for number of samples to take: " + samplesString + ". Skipping sampling.");
                }
                this.setNumLineSamples(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInputFormat.FileBaseStatistics getStatistics(BaseStatistics cachedStats) throws IOException {
        FileInputFormat.FileBaseStatistics cachedFileStats = cachedStats instanceof FileInputFormat.FileBaseStatistics ? (FileInputFormat.FileBaseStatistics)cachedStats : null;
        long oldTimeout = this.openTimeout;
        int oldBufferSize = this.bufferSize;
        int oldLineLengthLimit = this.lineLengthLimit;
        try {
            int numSamples;
            ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>(1);
            FileInputFormat.FileBaseStatistics stats = this.getFileStats(cachedFileStats, this.getFilePaths(), allFiles);
            if (stats == null) {
                FileInputFormat.FileBaseStatistics fileBaseStatistics = null;
                return fileBaseStatistics;
            }
            if (stats.getAverageRecordWidth() != -1.0f || stats.getTotalInputSize() == -1L) {
                FileInputFormat.FileBaseStatistics fileBaseStatistics = stats;
                return fileBaseStatistics;
            }
            if (this.unsplittable) {
                FileInputFormat.FileBaseStatistics fileBaseStatistics = stats;
                return fileBaseStatistics;
            }
            if (this.numLineSamples != -1) {
                numSamples = this.numLineSamples;
            } else {
                int calcSamples = (int)(stats.getTotalInputSize() / 1024L);
                numSamples = Math.min(DEFAULT_MAX_NUM_SAMPLES, Math.max(DEFAULT_MIN_NUM_SAMPLES, calcSamples));
            }
            if (numSamples == 0) {
                FileInputFormat.FileBaseStatistics calcSamples = stats;
                return calcSamples;
            }
            if (numSamples < 0) {
                throw new RuntimeException("Error: Invalid number of samples: " + numSamples);
            }
            this.openTimeout = 10000L;
            this.bufferSize = 4096;
            this.lineLengthLimit = MAX_SAMPLE_LEN;
            long offset = 0L;
            long totalNumBytes = 0L;
            long stepSize = stats.getTotalInputSize() / (long)numSamples;
            int fileNum = 0;
            int samplesTaken = 0;
            while (samplesTaken < numSamples && fileNum < allFiles.size()) {
                FileStatus file = allFiles.get(fileNum);
                FileInputSplit split = new FileInputSplit(0, file.getPath(), offset, file.getLen() - offset, null);
                try {
                    this.open(split);
                    if (this.readLine()) {
                        totalNumBytes += (long)(this.currLen + this.delimiter.length);
                        ++samplesTaken;
                    }
                }
                finally {
                    super.close();
                }
                offset += stepSize;
                while (fileNum < allFiles.size() && offset >= (file = allFiles.get(fileNum)).getLen()) {
                    offset -= file.getLen();
                    ++fileNum;
                }
            }
            FileInputFormat.FileBaseStatistics fileBaseStatistics = new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), stats.getTotalInputSize(), (float)totalNumBytes / (float)samplesTaken);
            return fileBaseStatistics;
        }
        catch (IOException ioex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Could not determine statistics for files '" + Arrays.toString(this.getFilePaths()) + "' due to an io error: " + ioex.getMessage());
            }
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unexpected problem while getting the file statistics for files '" + Arrays.toString(this.getFilePaths()) + "': " + t.getMessage(), t);
            }
        }
        finally {
            this.openTimeout = oldTimeout;
            this.bufferSize = oldBufferSize;
            this.lineLengthLimit = oldLineLengthLimit;
        }
        return null;
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.initBuffers();
        this.offset = this.splitStart;
        if (this.splitStart != 0L) {
            this.stream.seek(this.offset);
            this.readLine();
            if (this.overLimit) {
                this.end = true;
            }
        } else {
            this.fillBuffer(0);
        }
        this.initializeSplit(split, null);
    }

    private void initBuffers() {
        int n = this.bufferSize = this.bufferSize <= 0 ? 0x100000 : this.bufferSize;
        if (this.bufferSize <= this.delimiter.length) {
            throw new IllegalArgumentException("Buffer size must be greater than length of delimiter.");
        }
        if (this.readBuffer == null || this.readBuffer.length != this.bufferSize) {
            this.readBuffer = new byte[this.bufferSize];
        }
        if (this.wrapBuffer == null || this.wrapBuffer.length < 256) {
            this.wrapBuffer = new byte[256];
        }
        this.readPos = 0;
        this.limit = 0;
        this.overLimit = false;
        this.end = false;
    }

    @Override
    public boolean reachedEnd() {
        return this.end;
    }

    @Override
    public OT nextRecord(OT record) throws IOException {
        if (this.readLine()) {
            return this.readRecord(record, this.currBuffer, this.currOffset, this.currLen);
        }
        this.end = true;
        return null;
    }

    @Override
    public void close() throws IOException {
        this.wrapBuffer = null;
        this.readBuffer = null;
        super.close();
    }

    protected final boolean readLine() throws IOException {
        if (this.stream == null || this.overLimit) {
            return false;
        }
        int countInWrapBuffer = 0;
        int delimPos = 0;
        while (true) {
            int count;
            if (this.readPos >= this.limit && !this.fillBuffer(delimPos)) {
                int countInReadBuffer = delimPos;
                if (countInWrapBuffer + countInReadBuffer > 0) {
                    if (countInReadBuffer > 0) {
                        if (this.wrapBuffer.length - countInWrapBuffer < countInReadBuffer) {
                            byte[] tmp = new byte[countInWrapBuffer + countInReadBuffer];
                            System.arraycopy(this.wrapBuffer, 0, tmp, 0, countInWrapBuffer);
                            this.wrapBuffer = tmp;
                        }
                        System.arraycopy(this.readBuffer, 0, this.wrapBuffer, countInWrapBuffer, countInReadBuffer);
                        countInWrapBuffer += countInReadBuffer;
                    }
                    this.offset += (long)countInWrapBuffer;
                    this.setResult(this.wrapBuffer, 0, countInWrapBuffer);
                    return true;
                }
                return false;
            }
            int startPos = this.readPos - delimPos;
            while (this.readPos < this.limit && delimPos < this.delimiter.length) {
                if (this.readBuffer[this.readPos] == this.delimiter[delimPos]) {
                    ++delimPos;
                } else {
                    this.readPos -= delimPos;
                    delimPos = 0;
                }
                ++this.readPos;
            }
            if (delimPos == this.delimiter.length) {
                int readBufferBytesRead = this.readPos - startPos;
                this.offset += (long)(countInWrapBuffer + readBufferBytesRead);
                count = readBufferBytesRead - this.delimiter.length;
                if (countInWrapBuffer > 0) {
                    if (this.wrapBuffer.length < countInWrapBuffer + count) {
                        byte[] nb = new byte[countInWrapBuffer + count];
                        System.arraycopy(this.wrapBuffer, 0, nb, 0, countInWrapBuffer);
                        this.wrapBuffer = nb;
                    }
                    if (count >= 0) {
                        System.arraycopy(this.readBuffer, 0, this.wrapBuffer, countInWrapBuffer, count);
                    }
                    this.setResult(this.wrapBuffer, 0, countInWrapBuffer + count);
                    return true;
                }
                this.setResult(this.readBuffer, startPos, count);
                return true;
            }
            count = this.limit - startPos;
            if ((long)countInWrapBuffer + (long)count > (long)this.lineLengthLimit) {
                throw new IOException("The record length exceeded the maximum record length (" + this.lineLengthLimit + ").");
            }
            int bytesToMove = count - delimPos;
            if (this.wrapBuffer.length - countInWrapBuffer < bytesToMove) {
                byte[] tmp = new byte[Math.max(this.wrapBuffer.length * 2, countInWrapBuffer + bytesToMove)];
                System.arraycopy(this.wrapBuffer, 0, tmp, 0, countInWrapBuffer);
                this.wrapBuffer = tmp;
            }
            System.arraycopy(this.readBuffer, startPos, this.wrapBuffer, countInWrapBuffer, bytesToMove);
            countInWrapBuffer += bytesToMove;
            System.arraycopy(this.readBuffer, this.readPos - delimPos, this.readBuffer, 0, delimPos);
        }
    }

    private void setResult(byte[] buffer, int offset, int len) {
        this.currBuffer = buffer;
        this.currOffset = offset;
        this.currLen = len;
    }

    private boolean fillBuffer(int offset) throws IOException {
        int toRead;
        int maxReadLength = this.readBuffer.length - offset;
        if (this.splitLength == -1L) {
            int read = this.stream.read(this.readBuffer, offset, maxReadLength);
            if (read == -1) {
                this.stream.close();
                this.stream = null;
                return false;
            }
            this.readPos = offset;
            this.limit = read + offset;
            return true;
        }
        if (this.splitLength > 0L) {
            toRead = this.splitLength > (long)maxReadLength ? maxReadLength : (int)this.splitLength;
        } else {
            toRead = maxReadLength;
            this.overLimit = true;
        }
        int read = this.stream.read(this.readBuffer, offset, toRead);
        if (read == -1) {
            this.stream.close();
            this.stream = null;
            return false;
        }
        this.splitLength -= (long)read;
        this.readPos = offset;
        this.limit = read + offset;
        return true;
    }

    @Override
    @PublicEvolving
    public Long getCurrentState() throws IOException {
        return this.offset;
    }

    @Override
    @PublicEvolving
    public void reopen(FileInputSplit split, Long state) throws IOException {
        Preconditions.checkNotNull(split, "reopen() cannot be called on a null split.");
        Preconditions.checkNotNull(state, "reopen() cannot be called with a null initial state.");
        Preconditions.checkArgument(state == -1L || state >= split.getStart(), " Illegal offset " + state + ", smaller than the splits start=" + split.getStart());
        if (split.getLength() != -1L && state > split.getStart() + split.getLength()) {
            this.end = true;
            return;
        }
        if (split.getStart() == state.longValue()) {
            this.open(split);
            return;
        }
        super.open(split);
        this.offset = state;
        this.initBuffers();
        this.stream.seek(this.offset);
        if (split.getLength() == -1L) {
            this.fillBuffer(0);
        } else {
            this.splitLength = this.splitStart + split.getLength() - this.offset;
        }
        this.initializeSplit(split, state);
    }

    protected void initializeSplit(FileInputSplit split, @Nullable Long state) throws IOException {
    }
}

