/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.RestartStrategyDescriptionUtils;

@Internal
public class ArchivedExecutionConfig
implements Serializable {
    private static final long serialVersionUID = 2907040336948181163L;
    private final String restartStrategyDescription;
    private final int parallelism;
    private final int maxParallelism;
    private final boolean objectReuseEnabled;
    private final long periodicMaterializeIntervalMillis;
    private final Map<String, String> globalJobParameters;

    public ArchivedExecutionConfig(ExecutionConfig ec) {
        this.restartStrategyDescription = RestartStrategyDescriptionUtils.getRestartStrategyDescription(ec.toConfiguration());
        this.maxParallelism = ec.getMaxParallelism();
        this.parallelism = ec.getParallelism();
        this.objectReuseEnabled = ec.isObjectReuseEnabled();
        this.periodicMaterializeIntervalMillis = ec.getPeriodicMaterializeIntervalMillis();
        this.globalJobParameters = ec.getGlobalJobParameters() != null && ec.getGlobalJobParameters().toMap() != null ? ec.getGlobalJobParameters().toMap() : Collections.emptyMap();
    }

    public ArchivedExecutionConfig(String restartStrategyDescription, int maxParallelism, int parallelism, boolean objectReuseEnabled, long periodicMaterializeIntervalMillis, Map<String, String> globalJobParameters) {
        this.restartStrategyDescription = restartStrategyDescription;
        this.maxParallelism = maxParallelism;
        this.parallelism = parallelism;
        this.objectReuseEnabled = objectReuseEnabled;
        this.periodicMaterializeIntervalMillis = periodicMaterializeIntervalMillis;
        this.globalJobParameters = globalJobParameters;
    }

    public String getRestartStrategyDescription() {
        return this.restartStrategyDescription;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getObjectReuseEnabled() {
        return this.objectReuseEnabled;
    }

    public long getPeriodicMaterializeIntervalMillis() {
        return this.periodicMaterializeIntervalMillis;
    }

    public Map<String, String> getGlobalJobParameters() {
        return this.globalJobParameters;
    }
}

