/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.types.Row;

@Internal
public final class TypeInfoDataTypeConverter {
    private static final Map<TypeInformation<?>, DataType> conversionMap = new HashMap();

    public static DataType toDataType(DataTypeFactory dataTypeFactory, TypeInformation<?> typeInfo) {
        return TypeInfoDataTypeConverter.toDataType(dataTypeFactory, typeInfo, false);
    }

    public static DataType toDataType(DataTypeFactory dataTypeFactory, TypeInformation<?> typeInfo, boolean forceNullability) {
        if (typeInfo instanceof DataTypeQueryable) {
            return ((DataTypeQueryable)((Object)typeInfo)).getDataType();
        }
        DataType foundDataType = conversionMap.get(typeInfo);
        if (foundDataType != null) {
            return foundDataType;
        }
        if (typeInfo instanceof RowTypeInfo) {
            return TypeInfoDataTypeConverter.convertToRowType(dataTypeFactory, (RowTypeInfo)typeInfo);
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            return TypeInfoDataTypeConverter.convertToArrayType(dataTypeFactory, typeInfo.getTypeClass(), ((ObjectArrayTypeInfo)typeInfo).getComponentInfo());
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            return TypeInfoDataTypeConverter.convertToArrayType(dataTypeFactory, typeInfo.getTypeClass(), ((BasicArrayTypeInfo)typeInfo).getComponentInfo());
        }
        if (typeInfo instanceof ListTypeInfo) {
            return TypeInfoDataTypeConverter.convertToListArrayType(dataTypeFactory, ((ListTypeInfo)typeInfo).getElementTypeInfo());
        }
        if (typeInfo instanceof MultisetTypeInfo) {
            return TypeInfoDataTypeConverter.convertToMultisetType(dataTypeFactory, ((MultisetTypeInfo)typeInfo).getElementTypeInfo());
        }
        if (typeInfo instanceof MapTypeInfo) {
            return TypeInfoDataTypeConverter.convertToMapType(dataTypeFactory, ((MapTypeInfo)typeInfo).getKeyTypeInfo(), ((MapTypeInfo)typeInfo).getValueTypeInfo());
        }
        if (typeInfo instanceof CompositeType) {
            return TypeInfoDataTypeConverter.convertToStructuredType(dataTypeFactory, (CompositeType)typeInfo, forceNullability);
        }
        return dataTypeFactory.createRawDataType(typeInfo);
    }

    private static DataType convertToRowType(DataTypeFactory dataTypeFactory, RowTypeInfo rowTypeInfo) {
        String[] fieldNames = rowTypeInfo.getFieldNames();
        DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, rowTypeInfo.getArity()).mapToObj(i -> {
            DataType fieldType = TypeInfoDataTypeConverter.toDataType(dataTypeFactory, rowTypeInfo.getTypeAt(i));
            return DataTypes.FIELD(fieldNames[i], (DataType)fieldType.nullable());
        }).toArray(DataTypes.Field[]::new);
        return (DataType)((DataType)DataTypes.ROW(fields).notNull()).bridgedTo(Row.class);
    }

    private static DataType convertToArrayType(DataTypeFactory dataTypeFactory, Class<?> arrayClass, TypeInformation<?> elementTypeInfo) {
        return (DataType)((DataType)DataTypes.ARRAY((DataType)TypeInfoDataTypeConverter.toDataType(dataTypeFactory, elementTypeInfo).nullable()).notNull()).bridgedTo(arrayClass);
    }

    private static DataType convertToListArrayType(DataTypeFactory dataTypeFactory, TypeInformation<?> elementTypeInfo) {
        return (DataType)((DataType)DataTypes.ARRAY(TypeInfoDataTypeConverter.toDataType(dataTypeFactory, elementTypeInfo)).notNull()).bridgedTo(List.class);
    }

    private static DataType convertToMultisetType(DataTypeFactory dataTypeFactory, TypeInformation<?> elementTypeInfo) {
        return (DataType)((DataType)DataTypes.MULTISET((DataType)TypeInfoDataTypeConverter.toDataType(dataTypeFactory, elementTypeInfo).nullable()).notNull()).bridgedTo(Map.class);
    }

    private static DataType convertToMapType(DataTypeFactory dataTypeFactory, TypeInformation<?> keyTypeInfo, TypeInformation<?> valueTypeInfo) {
        return (DataType)((DataType)DataTypes.MAP(TypeInfoDataTypeConverter.toDataType(dataTypeFactory, keyTypeInfo), (DataType)TypeInfoDataTypeConverter.toDataType(dataTypeFactory, valueTypeInfo).nullable()).notNull()).bridgedTo(Map.class);
    }

    private static DataType convertToStructuredType(DataTypeFactory dataTypeFactory, CompositeType<?> compositeType, boolean forceNullability) {
        List<String> fieldNamesReordered;
        boolean isNullable;
        int arity = compositeType.getArity();
        String[] fieldNames = compositeType.getFieldNames();
        Class<?> typeClass = compositeType.getTypeClass();
        LinkedHashMap<String, DataType> fieldDataTypes = new LinkedHashMap<String, DataType>();
        IntStream.range(0, arity).forEachOrdered(pos -> fieldDataTypes.put(fieldNames[pos], TypeInfoDataTypeConverter.toDataType(dataTypeFactory, compositeType.getTypeAt(pos))));
        if (compositeType instanceof PojoTypeInfo) {
            PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)compositeType;
            List<Field> pojoFields = IntStream.range(0, arity).mapToObj(pojoTypeInfo::getPojoFieldAt).map(PojoField::getField).collect(Collectors.toList());
            isNullable = true;
            fieldDataTypes.replaceAll((name, dataType) -> {
                Class<?> fieldClass = pojoFields.stream().filter(f -> f.getName().equals(name)).findFirst().orElseThrow(IllegalStateException::new).getType();
                if (fieldClass.isPrimitive()) {
                    return (DataType)((DataType)dataType.notNull()).bridgedTo(fieldClass);
                }
                return (DataType)dataType.nullable();
            });
            fieldNamesReordered = TypeInfoDataTypeConverter.extractStructuredTypeFieldOrder(typeClass, pojoFields);
        } else {
            isNullable = forceNullability;
            fieldDataTypes.replaceAll((name, dataType) -> {
                try {
                    Class<?> fieldClass = ExtractionUtils.getStructuredField(typeClass, name).getType();
                    if (fieldClass.isPrimitive()) {
                        return (DataType)((DataType)dataType.notNull()).bridgedTo(fieldClass);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return dataType;
            });
            fieldNamesReordered = null;
        }
        DataTypes.Field[] structuredFields = fieldNamesReordered != null ? (DataTypes.Field[])fieldNamesReordered.stream().map(name -> DataTypes.FIELD(name, (DataType)fieldDataTypes.get(name))).toArray(DataTypes.Field[]::new) : (DataTypes.Field[])fieldDataTypes.entrySet().stream().map(e -> DataTypes.FIELD((String)e.getKey(), (DataType)e.getValue())).toArray(DataTypes.Field[]::new);
        DataType structuredDataType = DataTypes.STRUCTURED(typeClass, structuredFields);
        if (isNullable) {
            return (DataType)structuredDataType.nullable();
        }
        return (DataType)structuredDataType.notNull();
    }

    @Nullable
    private static List<String> extractStructuredTypeFieldOrder(Class<?> typeClass, List<Field> fields) {
        try {
            ExtractionUtils.AssigningConstructor constructor = ExtractionUtils.extractAssigningConstructor(typeClass, fields);
            if (constructor == null) {
                return null;
            }
            return constructor.parameterNames;
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        conversionMap.put(Types.STRING, (DataType)((DataType)DataTypes.STRING().nullable()).bridgedTo(String.class));
        conversionMap.put(Types.BOOLEAN, (DataType)((DataType)DataTypes.BOOLEAN().notNull()).bridgedTo(Boolean.class));
        conversionMap.put(Types.BYTE, (DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.class));
        conversionMap.put(Types.SHORT, (DataType)((DataType)DataTypes.SMALLINT().notNull()).bridgedTo(Short.class));
        conversionMap.put(Types.INT, (DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.class));
        conversionMap.put(Types.LONG, (DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.class));
        conversionMap.put(Types.FLOAT, (DataType)((DataType)DataTypes.FLOAT().notNull()).bridgedTo(Float.class));
        conversionMap.put(Types.DOUBLE, (DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.class));
        conversionMap.put(Types.BIG_DEC, (DataType)((DataType)DataTypes.DECIMAL(38, 18).nullable()).bridgedTo(BigDecimal.class));
        conversionMap.put(Types.LOCAL_DATE, (DataType)((DataType)DataTypes.DATE().nullable()).bridgedTo(LocalDate.class));
        conversionMap.put(Types.LOCAL_TIME, (DataType)((DataType)DataTypes.TIME(9).nullable()).bridgedTo(LocalTime.class));
        conversionMap.put(Types.LOCAL_DATE_TIME, (DataType)((DataType)DataTypes.TIMESTAMP(9).nullable()).bridgedTo(LocalDateTime.class));
        conversionMap.put(Types.INSTANT, (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(9).bridgedTo(Instant.class));
        conversionMap.put(Types.SQL_DATE, (DataType)((DataType)DataTypes.DATE().nullable()).bridgedTo(Date.class));
        conversionMap.put(Types.SQL_TIME, (DataType)((DataType)DataTypes.TIME(0).nullable()).bridgedTo(Time.class));
        conversionMap.put(Types.SQL_TIMESTAMP, (DataType)((DataType)DataTypes.TIMESTAMP(9).nullable()).bridgedTo(Timestamp.class));
        conversionMap.put(PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BOOLEAN().notNull()).bridgedTo(Boolean.TYPE)).notNull()).bridgedTo(boolean[].class));
        conversionMap.put(PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)((DataType)DataTypes.BYTES().notNull()).bridgedTo(byte[].class));
        conversionMap.put(PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.SMALLINT().notNull()).bridgedTo(Short.TYPE)).notNull()).bridgedTo(short[].class));
        conversionMap.put(PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)).notNull()).bridgedTo(int[].class));
        conversionMap.put(PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)).notNull()).bridgedTo(long[].class));
        conversionMap.put(PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.FLOAT().notNull()).bridgedTo(Float.TYPE)).notNull()).bridgedTo(float[].class));
        conversionMap.put(PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO, (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)).bridgedTo(double[].class));
    }
}

