/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.internal.StaticResultProvider;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.results.FetchOrientation;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.api.results.ResultSetImpl;
import org.apache.flink.table.gateway.service.result.ResultStore;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(ResultFetcher.class);
    private static final int TABLE_RESULT_MAX_INITIAL_CAPACITY = 5000;
    private final OperationHandle operationHandle;
    private final ResolvedSchema resultSchema;
    private final PrintStyle printStyle;
    private final ResultStore resultStore;
    private final LinkedList<RowData> bufferedResults = new LinkedList();
    private final LinkedList<RowData> bufferedPrevResults = new LinkedList();
    private final RowDataToStringConverter converter;
    private final boolean isQueryResult;
    @Nullable
    private final JobID jobID;
    private final ResultKind resultKind;
    private long currentToken = 0L;
    private boolean noMoreResults = false;
    @Nullable
    private ResourceManager resourceManager;

    private ResultFetcher(OperationHandle operationHandle, ResolvedSchema resultSchema, CloseableIterator<RowData> resultRows, RowDataToStringConverter converter, boolean isQueryResult, @Nullable JobID jobID, ResultKind resultKind, PrintStyle printStyle) {
        this(operationHandle, resultSchema, resultRows, converter, isQueryResult, jobID, resultKind, 5000, printStyle);
    }

    @VisibleForTesting
    ResultFetcher(OperationHandle operationHandle, ResolvedSchema resultSchema, CloseableIterator<RowData> resultRows, RowDataToStringConverter converter, boolean isQueryResult, @Nullable JobID jobID, ResultKind resultKind, int maxBufferSize, PrintStyle printStyle) {
        this.operationHandle = operationHandle;
        this.resultSchema = resultSchema;
        this.resultStore = new ResultStore(resultRows, maxBufferSize);
        this.converter = converter;
        this.isQueryResult = isQueryResult;
        this.jobID = jobID;
        this.resultKind = resultKind;
        this.printStyle = printStyle;
    }

    private ResultFetcher(OperationHandle operationHandle, ResolvedSchema resultSchema, List<RowData> rows, @Nullable JobID jobID, ResultKind resultKind) {
        this.operationHandle = operationHandle;
        this.resultSchema = resultSchema;
        this.bufferedResults.addAll(rows);
        this.resultStore = ResultStore.DUMMY_RESULT_STORE;
        this.converter = StaticResultProvider.SIMPLE_ROW_DATA_TO_STRING_CONVERTER;
        this.isQueryResult = false;
        this.jobID = jobID;
        this.resultKind = resultKind;
        this.printStyle = TableResultUtils.buildPrintStyle(resultSchema, this.converter);
    }

    public static ResultFetcher fromTableResult(OperationHandle operationHandle, TableResultInternal tableResult, boolean isQueryResult) {
        if (isQueryResult) {
            JobID jobID = tableResult.getJobClient().orElseThrow(() -> new SqlExecutionException(String.format("Can't get job client for the operation %s.", operationHandle))).getJobID();
            return new ResultFetcher(operationHandle, tableResult.getResolvedSchema(), tableResult.collectInternal(), tableResult.getRowDataToStringConverter(), true, jobID, tableResult.getResultKind(), ((TableResultImpl)tableResult).getPrintStyle());
        }
        return new ResultFetcher(operationHandle, tableResult.getResolvedSchema(), CollectionUtil.iteratorToList(tableResult.collectInternal()), tableResult.getJobClient().map(JobClient::getJobID).orElse(null), tableResult.getResultKind());
    }

    public static ResultFetcher fromResults(OperationHandle operationHandle, ResolvedSchema resultSchema, List<RowData> results) {
        return ResultFetcher.fromResults(operationHandle, resultSchema, results, null, ResultKind.SUCCESS_WITH_CONTENT);
    }

    public static ResultFetcher fromResults(OperationHandle operationHandle, ResolvedSchema resultSchema, List<RowData> results, @Nullable JobID jobID, ResultKind resultKind) {
        return new ResultFetcher(operationHandle, resultSchema, results, jobID, resultKind);
    }

    public ResultFetcher withResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        return this;
    }

    public void close() {
        this.resultStore.close();
        if (this.resourceManager != null) {
            try {
                this.resourceManager.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ResolvedSchema getResultSchema() {
        return this.resultSchema;
    }

    public boolean isQueryResult() {
        return this.isQueryResult;
    }

    public PrintStyle getPrintStyle() {
        return this.printStyle;
    }

    @VisibleForTesting
    public RowDataToStringConverter getConverter() {
        return this.converter;
    }

    public synchronized ResultSet fetchResults(FetchOrientation orientation, int maxFetchSize) {
        long token;
        switch (orientation) {
            case FETCH_NEXT: {
                token = this.currentToken;
                break;
            }
            case FETCH_PRIOR: {
                token = this.currentToken - 1L;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown fetch orientation: %s.", new Object[]{orientation}));
            }
        }
        if (orientation == FetchOrientation.FETCH_NEXT && this.bufferedResults.isEmpty()) {
            this.resultStore.waitUntilHasData();
        }
        return this.fetchResults(token, maxFetchSize);
    }

    public synchronized ResultSet fetchResults(long token, int maxFetchSize) {
        if (maxFetchSize <= 0) {
            throw new IllegalArgumentException("The max rows should be larger than 0.");
        }
        if (token == this.currentToken) {
            if (this.noMoreResults) {
                LOG.debug("There is no more result for operation: {}.", (Object)this.operationHandle);
                return new ResultSetImpl(ResultSet.ResultType.EOS, null, this.resultSchema, Collections.emptyList(), this.converter, this.isQueryResult, this.jobID, this.resultKind);
            }
            this.bufferedPrevResults.clear();
            if (this.bufferedResults.isEmpty()) {
                Optional<List<RowData>> newResults = this.resultStore.retrieveRecords();
                if (newResults.isPresent()) {
                    this.bufferedResults.addAll((Collection<RowData>)newResults.get());
                } else {
                    this.noMoreResults = true;
                    return new ResultSetImpl(ResultSet.ResultType.EOS, null, this.resultSchema, Collections.emptyList(), this.converter, this.isQueryResult, this.jobID, this.resultKind);
                }
            }
            int resultSize = Math.min(this.bufferedResults.size(), maxFetchSize);
            LOG.debug("Fetching current result for operation: {}, token: {}, maxFetchSize: {}, resultSize: {}.", new Object[]{this.operationHandle, token, maxFetchSize, resultSize});
            ++this.currentToken;
            for (int i = 0; i < resultSize; ++i) {
                this.bufferedPrevResults.add(this.bufferedResults.removeFirst());
            }
            return new ResultSetImpl(ResultSet.ResultType.PAYLOAD, this.currentToken, this.resultSchema, new ArrayList<RowData>(this.bufferedPrevResults), this.converter, this.isQueryResult, this.jobID, this.resultKind);
        }
        if (token == this.currentToken - 1L && token >= 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching previous result for operation: {}, token: {}, maxFetchSize: {}", new Object[]{this.operationHandle, token, maxFetchSize});
            }
            if (maxFetchSize < this.bufferedPrevResults.size()) {
                String msg = String.format("As the same token is provided, fetch size must be not less than the previous returned buffer size. Previous returned result size is %s, current max_fetch_size to be %s.", this.bufferedPrevResults.size(), maxFetchSize);
                if (LOG.isDebugEnabled()) {
                    LOG.error(msg);
                }
                throw new SqlExecutionException(msg);
            }
            return new ResultSetImpl(ResultSet.ResultType.PAYLOAD, this.currentToken, this.resultSchema, new ArrayList<RowData>(this.bufferedPrevResults), this.converter, this.isQueryResult, this.jobID, this.resultKind);
        }
        String msg = this.currentToken == 0L ? "Expecting token to be 0, but found " + token + "." : "Expecting token to be " + this.currentToken + " or " + (this.currentToken - 1L) + ", but found " + token + ".";
        if (LOG.isDebugEnabled()) {
            LOG.error(msg);
        }
        throw new SqlExecutionException(msg);
    }

    @VisibleForTesting
    public ResultStore getResultStore() {
        return this.resultStore;
    }
}

