/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.application;

import java.io.OutputStream;
import java.util.Collections;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;
import org.apache.flink.table.gateway.service.application.Printer;
import org.apache.flink.table.gateway.service.application.ScriptExecutor;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.apache.flink.util.concurrent.Executors;

public class ScriptRunner {
    private static final SessionHandle SESSION_HANDLE = new SessionHandle(UUID.fromString("013059f8-760f-4390-b74d-d0818bd99365"));

    public static void run(String script) throws Exception {
        ScriptRunner.run(script, System.out);
    }

    @VisibleForTesting
    public static void run(String script, OutputStream outputStream) throws Exception {
        DefaultContext defaultContext = new DefaultContext((Configuration)StreamExecutionEnvironment.getExecutionEnvironment(new Configuration()).getConfiguration(), Collections.emptyList());
        SessionContext sessionContext = SessionContext.create(defaultContext, SESSION_HANDLE, SessionEnvironment.newBuilder().setSessionEndpointVersion(SqlGatewayRestAPIVersion.getDefaultVersion()).build(), Executors.newDirectExecutorService());
        try (AutoCloseable ignore = sessionContext::close;){
            new ScriptExecutor(sessionContext, new Printer(outputStream)).execute(script);
        }
    }
}

