/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing.functions;

import java.util.Collections;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.WrappingFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalProcessWindowContext;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.util.Collector;

public final class InternalAggregateProcessWindowFunction<T, ACC, V, R, K, W extends Window>
extends WrappingFunction<ProcessWindowFunction<V, R, K, W>>
implements InternalWindowFunction<Iterable<T>, R, K, W> {
    private static final long serialVersionUID = 1L;
    private final AggregateFunction<T, ACC, V> aggFunction;
    private final InternalProcessWindowContext<V, R, K, W> ctx;

    public InternalAggregateProcessWindowFunction(AggregateFunction<T, ACC, V> aggFunction, ProcessWindowFunction<V, R, K, W> windowFunction) {
        super(windowFunction);
        this.aggFunction = aggFunction;
        this.ctx = new InternalProcessWindowContext<V, R, K, W>(windowFunction);
    }

    @Override
    public void process(K key, W window, InternalWindowFunction.InternalWindowContext context, Iterable<T> input, Collector<R> out) throws Exception {
        ACC acc = this.aggFunction.createAccumulator();
        for (T val : input) {
            acc = this.aggFunction.add(val, acc);
        }
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ProcessWindowFunction wrappedFunction = (ProcessWindowFunction)this.wrappedFunction;
        wrappedFunction.process(key, this.ctx, Collections.singletonList(this.aggFunction.getResult(acc)), out);
    }

    @Override
    public void clear(W window, InternalWindowFunction.InternalWindowContext context) throws Exception {
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ProcessWindowFunction wrappedFunction = (ProcessWindowFunction)this.wrappedFunction;
        wrappedFunction.clear(this.ctx);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }

    @Override
    public IterationRuntimeContext getIterationRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }
}

