/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.MapPartitionIterator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OperatorAttributes;
import org.apache.flink.streaming.api.operators.OperatorAttributesBuilder;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.ExceptionUtils;

@Internal
public class MapPartitionOperator<IN, OUT>
extends AbstractUdfStreamOperator<OUT, MapPartitionFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    private final MapPartitionFunction<IN, OUT> function;
    private transient MapPartitionIterator<IN> iterator;

    public MapPartitionOperator(MapPartitionFunction<IN, OUT> function) {
        super(function);
        this.function = function;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.iterator = new MapPartitionIterator(iterator -> {
            TimestampedCollector outputCollector = new TimestampedCollector(this.output);
            try {
                this.function.mapPartition(() -> iterator, outputCollector);
            }
            catch (Exception e) {
                ExceptionUtils.rethrow(e);
            }
        });
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.iterator.addRecord(element.getValue());
    }

    @Override
    public void endInput() throws Exception {
        this.iterator.close();
    }

    @Override
    public OperatorAttributes getOperatorAttributes() {
        return new OperatorAttributesBuilder().setOutputOnlyAfterEndOfStream(true).build();
    }
}

