/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.util.FileUtils;

public abstract class SnapshotDirectory {
    @Nonnull
    protected final Path directory;
    @Nonnull
    protected AtomicReference<State> state;

    private SnapshotDirectory(@Nonnull Path directory) {
        this.directory = directory;
        this.state = new AtomicReference<State>(State.ONGOING);
    }

    @Nonnull
    public Path getDirectory() {
        return this.directory;
    }

    public boolean mkdirs() throws IOException {
        Files.createDirectories(this.directory, new FileAttribute[0]);
        return true;
    }

    public boolean exists() throws IOException {
        return Files.exists(this.directory, new LinkOption[0]);
    }

    public Path[] listDirectory() throws IOException {
        return FileUtils.listDirectory(this.directory);
    }

    public boolean cleanup() throws IOException {
        if (this.state.compareAndSet(State.ONGOING, State.DELETED)) {
            FileUtils.deleteDirectory(this.directory.toFile());
        }
        return true;
    }

    public boolean isSnapshotCompleted() {
        return State.COMPLETED == this.state.get();
    }

    @Nullable
    public abstract DirectoryStateHandle completeSnapshotAndGetHandle() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotDirectory that = (SnapshotDirectory)o;
        return this.directory.equals(that.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public String toString() {
        return "SnapshotDirectory{directory=" + this.directory + ", state=" + this.state + "}";
    }

    public static SnapshotDirectory temporary(@Nonnull File directory) throws IOException {
        return new TemporarySnapshotDirectory(directory);
    }

    public static SnapshotDirectory permanent(@Nonnull Path directory) throws IOException {
        return new PermanentSnapshotDirectory(directory);
    }

    private static class PermanentSnapshotDirectory
    extends SnapshotDirectory {
        PermanentSnapshotDirectory(@Nonnull Path directory) {
            super(directory);
        }

        @Override
        public DirectoryStateHandle completeSnapshotAndGetHandle() throws IOException {
            if (State.COMPLETED == this.state.get() || this.state.compareAndSet(State.ONGOING, State.COMPLETED)) {
                return DirectoryStateHandle.forPathWithSize(this.directory);
            }
            throw new IOException("Expected state " + State.ONGOING + " but found state " + this.state.get());
        }
    }

    private static class TemporarySnapshotDirectory
    extends SnapshotDirectory {
        TemporarySnapshotDirectory(@Nonnull File directory) throws IOException {
            super(directory.toPath());
        }

        @Override
        public DirectoryStateHandle completeSnapshotAndGetHandle() {
            return null;
        }
    }

    static enum State {
        ONGOING,
        COMPLETED,
        DELETED;

    }
}

