/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.failover.ResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class ExecutionGraphResultPartitionAvailabilityChecker
implements ResultPartitionAvailabilityChecker {
    private final Function<IntermediateResultPartitionID, ResultPartitionID> partitionIDMapper;
    private final JobMasterPartitionTracker partitionTracker;

    ExecutionGraphResultPartitionAvailabilityChecker(Function<IntermediateResultPartitionID, ResultPartitionID> partitionIDMapper, JobMasterPartitionTracker partitionTracker) {
        this.partitionIDMapper = Preconditions.checkNotNull(partitionIDMapper);
        this.partitionTracker = Preconditions.checkNotNull(partitionTracker);
    }

    @Override
    public boolean isAvailable(IntermediateResultPartitionID resultPartitionID) {
        return this.partitionTracker.isPartitionTracked(this.partitionIDMapper.apply(resultPartitionID));
    }
}

