/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class WebOptions {
    public static final ConfigOption<String> ACCESS_CONTROL_ALLOW_ORIGIN = ConfigOptions.key("web.access-control-allow-origin").stringType().defaultValue("*").withDeprecatedKeys("jobmanager.web.access-control-allow-origin").withDescription("Access-Control-Allow-Origin header for all responses from the web-frontend.");
    public static final ConfigOption<Duration> REFRESH_INTERVAL = ConfigOptions.key("web.refresh-interval").durationType().defaultValue(Duration.ofMillis(3000L)).withDeprecatedKeys("jobmanager.web.refresh-interval").withDescription("Refresh interval for the web-frontend.");
    @Documentation.OverrideDefault(value="System.getProperty(\"java.io.tmpdir\")")
    public static final ConfigOption<String> TMP_DIR = ConfigOptions.key("web.tmpdir").stringType().defaultValue(System.getProperty("java.io.tmpdir")).withDeprecatedKeys("jobmanager.web.tmpdir").withDescription("Local directory that is used by the REST API for temporary files.");
    public static final ConfigOption<String> UPLOAD_DIR = ConfigOptions.key("web.upload.dir").stringType().noDefaultValue().withDeprecatedKeys("jobmanager.web.upload.dir").withDescription(Description.builder().text("Local directory that is used by the REST API for storing uploaded jars. If not specified a dynamic directory will be created under %s.", TextElement.code(TMP_DIR.key())).build());
    public static final ConfigOption<Integer> ARCHIVE_COUNT = ConfigOptions.key("web.history").intType().defaultValue(5).withDeprecatedKeys("jobmanager.web.history").withDescription("Number of archived jobs for the JobManager.");
    public static final ConfigOption<String> LOG_PATH = ConfigOptions.key("web.log.path").stringType().noDefaultValue().withDeprecatedKeys("jobmanager.web.log.path").withDescription("Path to the log file (may be in /log for standalone but under log directory when using YARN).");
    public static final ConfigOption<Boolean> SUBMIT_ENABLE = ConfigOptions.key("web.submit.enable").booleanType().defaultValue(true).withDeprecatedKeys("jobmanager.web.submit.enable").withDescription("Flag indicating whether jobs can be uploaded and run from the web-frontend.");
    public static final ConfigOption<Boolean> CANCEL_ENABLE = ConfigOptions.key("web.cancel.enable").booleanType().defaultValue(true).withDescription("Flag indicating whether jobs can be canceled from the web-frontend.");
    public static final ConfigOption<Boolean> RESCALE_ENABLE = ConfigOptions.key("web.rescale.enable").booleanType().defaultValue(true).withDescription("Flag indicating whether jobs can be rescaled from the web-frontend.");
    public static final ConfigOption<Integer> CHECKPOINTS_HISTORY_SIZE = ConfigOptions.key("web.checkpoints.history").intType().defaultValue(10).withDeprecatedKeys("jobmanager.web.checkpoints.history").withDescription("Number of checkpoints to remember for recent history.");
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<Integer> MAX_EXCEPTION_HISTORY_SIZE = ConfigOptions.key("web.exception-history-size").intType().defaultValue(16).withDescription("The maximum number of failures collected by the exception history per job.");
    public static final ConfigOption<Duration> TIMEOUT = ConfigOptions.key("web.timeout").durationType().defaultValue(Duration.ofMillis(600000L)).withDescription("Timeout for asynchronous operations by the web monitor.");

    private WebOptions() {
    }
}

