/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.lang.reflect.Constructor;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateComparator;
import org.apache.flink.api.common.typeutils.base.LocalDateSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeComparator;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalTimeComparator;
import org.apache.flink.api.common.typeutils.base.LocalTimeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class LocalTimeTypeInfo<T extends Temporal>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeTypeInfo<LocalDate> LOCAL_DATE = new LocalTimeTypeInfo<LocalDate>(LocalDate.class, LocalDateSerializer.INSTANCE, LocalDateComparator.class);
    public static final LocalTimeTypeInfo<LocalTime> LOCAL_TIME = new LocalTimeTypeInfo<LocalTime>(LocalTime.class, LocalTimeSerializer.INSTANCE, LocalTimeComparator.class);
    public static final LocalTimeTypeInfo<LocalDateTime> LOCAL_DATE_TIME = new LocalTimeTypeInfo<LocalDateTime>(LocalDateTime.class, LocalDateTimeSerializer.INSTANCE, LocalDateTimeComparator.class);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private final Class<? extends TypeComparator<T>> comparatorClass;

    protected LocalTimeTypeInfo(Class<T> clazz, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.comparatorClass = Preconditions.checkNotNull(comparatorClass);
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<T> createSerializer(SerializerConfig serializerConfig) {
        return this.serializer;
    }

    @Override
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        return LocalTimeTypeInfo.instantiateComparator(this.comparatorClass, sortOrderAscending);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clazz, this.serializer, this.comparatorClass);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof LocalTimeTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LocalTimeTypeInfo) {
            LocalTimeTypeInfo other = (LocalTimeTypeInfo)obj;
            return other.canEqual(this) && this.clazz == other.clazz && this.serializer.equals(other.serializer) && this.comparatorClass == other.comparatorClass;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.clazz.getSimpleName();
    }

    private static <X> TypeComparator<X> instantiateComparator(Class<? extends TypeComparator<X>> comparatorClass, boolean ascendingOrder) {
        try {
            Constructor<TypeComparator<X>> constructor = comparatorClass.getConstructor(Boolean.TYPE);
            return constructor.newInstance(ascendingOrder);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize comparator " + comparatorClass.getName(), e);
        }
    }

    public static LocalTimeTypeInfo getInfoFor(Class type) {
        Preconditions.checkNotNull(type);
        if (type == LocalDate.class) {
            return LOCAL_DATE;
        }
        if (type == LocalTime.class) {
            return LOCAL_TIME;
        }
        if (type == LocalDateTime.class) {
            return LOCAL_DATE_TIME;
        }
        return null;
    }
}

