/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public final class PercentageArrayArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final boolean expectedNullability;

    public PercentageArrayArgumentTypeStrategy(boolean nullable) {
        this.expectedNullability = nullable;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        LogicalType actualType = callContext.getArgumentDataTypes().get(argumentPos).getLogicalType();
        if (!actualType.is(LogicalTypeRoot.ARRAY)) {
            return callContext.fail(throwOnFailure, "Percentage must be an array.", new Object[0]);
        }
        if (!this.expectedNullability && actualType.isNullable()) {
            return callContext.fail(throwOnFailure, "Percentage must be a non-null array.", new Object[0]);
        }
        LogicalType elementType = ((ArrayType)actualType).getElementType();
        if (!elementType.is(LogicalTypeFamily.NUMERIC)) {
            return callContext.fail(throwOnFailure, "Value in the percentage array must be of NUMERIC type.", new Object[0]);
        }
        if (!this.expectedNullability && elementType.isNullable()) {
            return callContext.fail(throwOnFailure, "Value in the percentage array must be of NOT NULL type.", new Object[0]);
        }
        if (callContext.isArgumentLiteral(argumentPos)) {
            Optional<Number[]> literalVal = callContext.getArgumentValue(argumentPos, Number[].class);
            if (!literalVal.isPresent()) {
                return callContext.fail(throwOnFailure, "Percentage must be an array of NUMERIC values between [0.0, 1.0].", new Object[0]);
            }
            for (Number value : literalVal.get()) {
                if (!(value.doubleValue() < 0.0) && !(value.doubleValue() > 1.0)) continue;
                return callContext.fail(throwOnFailure, "Value in the percentage array must be between [0.0, 1.0], but was '%s'.", value.doubleValue());
            }
        }
        return Optional.of(this.expectedNullability ? DataTypes.ARRAY(DataTypes.DOUBLE()) : (DataType)DataTypes.ARRAY((DataType)DataTypes.DOUBLE().notNull()).notNull());
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of(this.expectedNullability ? "ARRAY<NUMERIC>" : "ARRAY<NUMERIC NOT NULL> NOT NULL");
    }
}

