/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FieldReferenceExpression
implements ResolvedExpression {
    private final String name;
    private final DataType dataType;
    private final int inputIndex;
    private final int fieldIndex;
    @Nullable
    private final String inputAlias;

    public FieldReferenceExpression(String name, DataType dataType, int inputIndex, int fieldIndex) {
        this(name, dataType, inputIndex, fieldIndex, null);
    }

    public FieldReferenceExpression(String name, DataType dataType, int inputIndex, int fieldIndex, @Nullable String inputAlias) {
        Preconditions.checkArgument(inputIndex >= 0, "Index of input should be a positive number");
        Preconditions.checkArgument(fieldIndex >= 0, "Index of field should be a positive number");
        this.name = Preconditions.checkNotNull(name, "Field name must not be null.");
        this.dataType = Preconditions.checkNotNull(dataType, "Field data type must not be null.");
        this.inputIndex = inputIndex;
        this.fieldIndex = fieldIndex;
        this.inputAlias = inputAlias;
    }

    public String getName() {
        return this.name;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    @Override
    public DataType getOutputDataType() {
        return this.dataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    @Override
    public String asSummaryString() {
        return this.name;
    }

    @Override
    public String asSerializableString() {
        if (this.inputAlias != null) {
            return String.format("%s.%s", EncodingUtils.escapeIdentifier(this.inputAlias), EncodingUtils.escapeIdentifier(this.name));
        }
        return EncodingUtils.escapeIdentifier(this.name);
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldReferenceExpression that = (FieldReferenceExpression)o;
        return this.name.equals(that.name) && this.dataType.equals(that.dataType) && this.inputIndex == that.inputIndex && this.fieldIndex == that.fieldIndex && Objects.equals(this.inputAlias, that.inputAlias);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.inputIndex, this.fieldIndex, this.inputAlias);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

