/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks.mailbox;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.SystemClock;

@Internal
public class MailboxMetricsController {
    public final int defaultLatencyMeasurementInterval = 1000;
    private final Histogram latencyHistogram;
    private final Counter mailCounter;
    @Nullable
    private TimerService timerService = null;
    @Nullable
    private MailboxExecutor mailboxExecutor = null;
    private int measurementInterval = 1000;
    private boolean started = false;

    public MailboxMetricsController(Histogram latencyHistogram, Counter mailCounter) {
        this.latencyHistogram = latencyHistogram;
        this.mailCounter = mailCounter;
    }

    public void setupLatencyMeasurement(TimerService timerService, MailboxExecutor mailboxExecutor) {
        Preconditions.checkState(!this.isLatencyMeasurementSetup(), "latency measurement has already been setup and cannot be setup twice");
        this.timerService = timerService;
        this.mailboxExecutor = mailboxExecutor;
    }

    public void startLatencyMeasurement() {
        Preconditions.checkState(!this.isLatencyMeasurementStarted(), "latency measurement has already been started");
        Preconditions.checkState(this.isLatencyMeasurementSetup(), "timer service and mailbox executor must be setup for latency measurement");
        this.scheduleLatencyMeasurement();
        this.started = true;
    }

    public boolean isLatencyMeasurementStarted() {
        return this.started;
    }

    public boolean isLatencyMeasurementSetup() {
        return this.timerService != null && this.mailboxExecutor != null;
    }

    public Counter getMailCounter() {
        return this.mailCounter;
    }

    @VisibleForTesting
    public void setLatencyMeasurementInterval(int measurementInterval) {
        this.measurementInterval = measurementInterval;
    }

    @VisibleForTesting
    public void measureMailboxLatency() {
        assert (this.mailboxExecutor != null);
        long startTime = SystemClock.getInstance().relativeTimeMillis();
        this.mailboxExecutor.execute(() -> {
            long endTime = SystemClock.getInstance().relativeTimeMillis();
            long latency = endTime - startTime;
            this.latencyHistogram.update(latency);
            this.scheduleLatencyMeasurement();
        }, "Measure mailbox latency metric");
    }

    private void scheduleLatencyMeasurement() {
        assert (this.timerService != null);
        this.timerService.registerTimer(this.timerService.getCurrentProcessingTime() + (long)this.measurementInterval, timestamp -> this.measureMailboxLatency());
    }
}

