/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.runtime.io.DataInputStatus;
import org.apache.flink.streaming.runtime.io.FinishedDataOutput;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.RecoverableStreamTaskInput;
import org.apache.flink.streaming.runtime.io.StreamInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class StreamOneInputProcessor<IN>
implements StreamInputProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StreamOneInputProcessor.class);
    private StreamTaskInput<IN> input;
    private PushingAsyncDataInput.DataOutput<IN> output;
    private final BoundedMultiInput endOfInputAware;

    public StreamOneInputProcessor(StreamTaskInput<IN> input, PushingAsyncDataInput.DataOutput<IN> output, BoundedMultiInput endOfInputAware) {
        this.input = Preconditions.checkNotNull(input);
        this.output = Preconditions.checkNotNull(output);
        this.endOfInputAware = Preconditions.checkNotNull(endOfInputAware);
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.input.getAvailableFuture();
    }

    @Override
    public DataInputStatus processInput() throws Exception {
        DataInputStatus status = this.input.emitNext(this.output);
        if (status == DataInputStatus.END_OF_DATA) {
            this.endOfInputAware.endInput(this.input.getInputIndex() + 1);
            this.output = new FinishedDataOutput();
        } else if (status == DataInputStatus.END_OF_RECOVERY) {
            if (this.input instanceof RecoverableStreamTaskInput) {
                this.input = ((RecoverableStreamTaskInput)this.input).finishRecovery();
            }
            return DataInputStatus.MORE_AVAILABLE;
        }
        return status;
    }

    @Override
    public CompletableFuture<Void> prepareSnapshot(ChannelStateWriter channelStateWriter, long checkpointId) throws CheckpointException {
        return this.input.prepareSnapshot(channelStateWriter, checkpointId);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

