/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.ttl.AbstractTtlState;
import org.apache.flink.runtime.state.ttl.TtlStateContext;
import org.apache.flink.runtime.state.ttl.TtlUtils;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.Preconditions;

class TtlListState<K, N, T>
extends AbstractTtlState<K, N, List<T>, List<TtlValue<T>>, InternalListState<K, N, TtlValue<T>>>
implements InternalListState<K, N, T> {
    TtlListState(TtlStateContext<InternalListState<K, N, TtlValue<T>>, List<T>> ttlStateContext) {
        super(ttlStateContext);
    }

    @Override
    public void update(List<T> values) throws Exception {
        this.accessCallback.run();
        this.updateInternal(values);
    }

    @Override
    public void addAll(List<T> values) throws Exception {
        this.accessCallback.run();
        Preconditions.checkNotNull(values, "List of values to add cannot be null.");
        ((InternalListState)this.original).addAll(this.withTs(values));
    }

    @Override
    public Iterable<T> get() throws Exception {
        this.accessCallback.run();
        Iterable<Object> ttlValue = (Iterable)((InternalListState)this.original).get();
        Iterable<Object> iterable = ttlValue = ttlValue == null ? Collections.emptyList() : ttlValue;
        if (this.updateTsOnRead) {
            List<TtlValue<T>> collected = this.collect(ttlValue);
            ttlValue = collected;
            this.updateTs(collected);
        }
        Iterable<Object> finalResult = ttlValue;
        return () -> new IteratorWithCleanup(finalResult.iterator());
    }

    private void updateTs(List<TtlValue<T>> ttlValues) throws Exception {
        ArrayList<TtlValue<T>> unexpiredWithUpdatedTs = new ArrayList<TtlValue<T>>(ttlValues.size());
        long currentTimestamp = this.timeProvider.currentTimestamp();
        for (TtlValue<T> ttlValue : ttlValues) {
            if (TtlUtils.expired(ttlValue, this.ttl, currentTimestamp)) continue;
            unexpiredWithUpdatedTs.add(TtlUtils.wrapWithTs(ttlValue.getUserValue(), currentTimestamp));
        }
        if (!unexpiredWithUpdatedTs.isEmpty()) {
            ((InternalListState)this.original).update(unexpiredWithUpdatedTs);
        }
    }

    @Override
    public void add(T value) throws Exception {
        this.accessCallback.run();
        Preconditions.checkNotNull(value, "You cannot add null to a ListState.");
        ((InternalListState)this.original).add(this.wrapWithTs(value));
    }

    @Override
    @Nullable
    public List<TtlValue<T>> getUnexpiredOrNull(@Nonnull List<TtlValue<T>> ttlValues) {
        if (ttlValues.isEmpty()) {
            return ttlValues;
        }
        long currentTimestamp = this.timeProvider.currentTimestamp();
        TypeSerializer<TtlValue<T>> elementSerializer = ((ListSerializer)((InternalListState)this.original).getValueSerializer()).getElementSerializer();
        int firstExpireElementIndex = -1;
        for (int i = 0; i < ttlValues.size(); ++i) {
            TtlValue<T> ttlValue = ttlValues.get(i);
            if (!TtlUtils.expired(ttlValue, this.ttl, currentTimestamp)) continue;
            firstExpireElementIndex = i;
            break;
        }
        if (firstExpireElementIndex == -1) {
            return ttlValues;
        }
        ArrayList<TtlValue<T>> unexpired = new ArrayList<TtlValue<T>>(ttlValues.size());
        for (int i = 0; i < ttlValues.size(); ++i) {
            TtlValue<T> ttlValue = ttlValues.get(i);
            if (i >= firstExpireElementIndex && (i <= firstExpireElementIndex || TtlUtils.expired(ttlValue, this.ttl, currentTimestamp))) continue;
            unexpired.add(elementSerializer.copy(ttlValue));
        }
        if (!unexpired.isEmpty()) {
            return unexpired;
        }
        return null;
    }

    @Override
    public void clear() {
        ((InternalListState)this.original).clear();
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        ((InternalListState)this.original).mergeNamespaces(target, sources);
    }

    @Override
    public List<T> getInternal() throws Exception {
        return this.collect((Iterable)this.get());
    }

    private <E> List<E> collect(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : iterable) {
            list.add(element);
        }
        return list;
    }

    @Override
    public void updateInternal(List<T> valueToStore) throws Exception {
        Preconditions.checkNotNull(valueToStore, "List of values to update cannot be null.");
        ((InternalListState)this.original).update(this.withTs(valueToStore));
    }

    private List<TtlValue<T>> withTs(List<T> values) {
        long currentTimestamp = this.timeProvider.currentTimestamp();
        ArrayList<TtlValue<T>> withTs = new ArrayList<TtlValue<T>>(values.size());
        for (T value : values) {
            Preconditions.checkNotNull(value, "You cannot have null element in a ListState.");
            withTs.add(TtlUtils.wrapWithTs(value, currentTimestamp));
        }
        return withTs;
    }

    private class IteratorWithCleanup
    implements Iterator<T> {
        private final Iterator<TtlValue<T>> originalIterator;
        private boolean anyUnexpired = false;
        private boolean uncleared = true;
        private T nextUnexpired = null;

        private IteratorWithCleanup(Iterator<TtlValue<T>> ttlIterator) {
            this.originalIterator = ttlIterator;
        }

        @Override
        public boolean hasNext() {
            this.findNextUnexpired();
            this.cleanupIfEmpty();
            return this.nextUnexpired != null;
        }

        private void cleanupIfEmpty() {
            boolean endOfIter;
            boolean bl = endOfIter = !this.originalIterator.hasNext() && this.nextUnexpired == null;
            if (this.uncleared && !this.anyUnexpired && endOfIter) {
                ((InternalListState)TtlListState.this.original).clear();
                this.uncleared = false;
            }
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                Object result = this.nextUnexpired;
                this.nextUnexpired = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        private void findNextUnexpired() {
            TtlValue ttlValue;
            while (this.nextUnexpired == null && this.originalIterator.hasNext() && (ttlValue = this.originalIterator.next()) != null) {
                boolean unexpired;
                boolean bl = unexpired = !TtlListState.this.expired(ttlValue);
                if (unexpired) {
                    this.anyUnexpired = true;
                }
                if (!unexpired && !TtlListState.this.returnExpired) continue;
                this.nextUnexpired = ttlValue.getUserValue();
            }
        }
    }
}

