/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializer;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;

public class TtlAwareSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private static final int CURRENT_VERSION = 1;
    private boolean isTtlEnabled;
    private TypeSerializerSnapshot<T> typeSerializerSnapshot;

    public TtlAwareSerializerSnapshot() {
    }

    public TtlAwareSerializerSnapshot(TypeSerializerSnapshot<T> typeSerializerSnapshot, boolean isTtlEnabled) {
        this.typeSerializerSnapshot = typeSerializerSnapshot;
        this.isTtlEnabled = isTtlEnabled;
    }

    public TtlAwareSerializerSnapshot(TypeSerializerSnapshot<T> typeSerializerSnapshot) {
        this.typeSerializerSnapshot = typeSerializerSnapshot;
        this.isTtlEnabled = typeSerializerSnapshot instanceof TtlStateFactory.TtlSerializerSnapshot;
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        out.writeBoolean(this.isTtlEnabled);
        TypeSerializerSnapshot.writeVersionedSnapshot(out, this.typeSerializerSnapshot);
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.isTtlEnabled = in.readBoolean();
        this.typeSerializerSnapshot = TypeSerializerSnapshot.readVersionedSnapshot(in, userCodeClassLoader);
    }

    @Override
    public TypeSerializer<T> restoreSerializer() {
        return new TtlAwareSerializer<T>(this.typeSerializerSnapshot.restoreSerializer());
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
        if (!(oldSerializerSnapshot instanceof TtlAwareSerializerSnapshot)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        TtlAwareSerializerSnapshot oldTtlAwareSerializerSnapshot = (TtlAwareSerializerSnapshot)oldSerializerSnapshot;
        if (!oldTtlAwareSerializerSnapshot.isTtlEnabled() && this.isTtlEnabled()) {
            TtlStateFactory.TtlSerializerSnapshot newSerializerSnapshot = (TtlStateFactory.TtlSerializerSnapshot)this.getOrinalTypeSerializerSnapshot();
            TypeSerializerSchemaCompatibility compatibility = newSerializerSnapshot.getValueSerializerSnapshot().resolveSchemaCompatibility(oldTtlAwareSerializerSnapshot.getOrinalTypeSerializerSnapshot());
            return this.resolveCompatibilityForTtlMigration(compatibility);
        }
        if (oldTtlAwareSerializerSnapshot.isTtlEnabled() && !this.isTtlEnabled()) {
            TtlStateFactory.TtlSerializerSnapshot oldTtlSerializerSnapshot = (TtlStateFactory.TtlSerializerSnapshot)oldTtlAwareSerializerSnapshot.getOrinalTypeSerializerSnapshot();
            TypeSerializerSchemaCompatibility<T> compatibility = this.getOrinalTypeSerializerSnapshot().resolveSchemaCompatibility(oldTtlSerializerSnapshot.getValueSerializerSnapshot());
            return this.resolveCompatibilityForTtlMigration(compatibility);
        }
        return this.getOrinalTypeSerializerSnapshot().resolveSchemaCompatibility(oldTtlAwareSerializerSnapshot.getOrinalTypeSerializerSnapshot());
    }

    public boolean isTtlEnabled() {
        return this.isTtlEnabled;
    }

    public TypeSerializerSnapshot<T> getOrinalTypeSerializerSnapshot() {
        return this.typeSerializerSnapshot;
    }

    private TypeSerializerSchemaCompatibility<T> resolveCompatibilityForTtlMigration(TypeSerializerSchemaCompatibility<T> originalCompatibility) {
        if (originalCompatibility.isCompatibleAsIs() || originalCompatibility.isCompatibleAfterMigration() || originalCompatibility.isCompatibleWithReconfiguredSerializer()) {
            return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }
}

