/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.LocalSnapshotDirectoryProvider;
import org.apache.flink.util.Preconditions;

public class LocalRecoveryConfig {
    public static final LocalRecoveryConfig BACKUP_AND_RECOVERY_DISABLED = new LocalRecoveryConfig(false, false, null);
    private final boolean localRecoveryEnabled;
    private final boolean localBackupEnabled;
    @Nullable
    private final LocalSnapshotDirectoryProvider localStateDirectories;

    public LocalRecoveryConfig(boolean localRecoveryEnabled, boolean localBackupEnabled, @Nullable LocalSnapshotDirectoryProvider directoryProvider) {
        this.localRecoveryEnabled = localRecoveryEnabled;
        this.localBackupEnabled = localBackupEnabled;
        this.localStateDirectories = directoryProvider;
    }

    public boolean isLocalRecoveryEnabled() {
        return this.localRecoveryEnabled;
    }

    public boolean isLocalBackupEnabled() {
        return this.localBackupEnabled;
    }

    public boolean isLocalRecoveryOrLocalBackupEnabled() {
        return this.localRecoveryEnabled || this.localBackupEnabled;
    }

    public Optional<LocalSnapshotDirectoryProvider> getLocalStateDirectoryProvider() {
        return Optional.ofNullable(this.localStateDirectories);
    }

    public String toString() {
        return "LocalRecoveryConfig{localStateDirectories=" + this.localStateDirectories + "}";
    }

    public static Supplier<IllegalStateException> localRecoveryNotEnabled() {
        return () -> new IllegalStateException("Getting a LocalRecoveryDirectoryProvider is only supported with the local recovery enabled. This is a bug and should be reported.");
    }

    public static LocalRecoveryConfig backupAndRecoveryEnabled(@Nonnull LocalSnapshotDirectoryProvider directoryProvider) {
        return new LocalRecoveryConfig(true, true, Preconditions.checkNotNull(directoryProvider));
    }
}

