/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolServiceFactory;
import org.apache.flink.util.clock.Clock;

public class DeclarativeSlotPoolServiceFactory
implements SlotPoolServiceFactory {
    private final Clock clock;
    private final Duration idleSlotTimeout;
    private final Duration rpcTimeout;
    @Nonnull
    private final Duration slotRequestMaxInterval;

    public DeclarativeSlotPoolServiceFactory(Clock clock, Duration idleSlotTimeout, Duration rpcTimeout, @Nonnull Duration slotRequestMaxInterval) {
        this.clock = clock;
        this.idleSlotTimeout = idleSlotTimeout;
        this.rpcTimeout = rpcTimeout;
        this.slotRequestMaxInterval = slotRequestMaxInterval;
    }

    @Override
    @Nonnull
    public SlotPoolService createSlotPoolService(@Nonnull JobID jobId, DeclarativeSlotPoolFactory declarativeSlotPoolFactory, @Nonnull ComponentMainThreadExecutor componentMainThreadExecutor) {
        return new DeclarativeSlotPoolService(jobId, declarativeSlotPoolFactory, this.clock, this.idleSlotTimeout, this.rpcTimeout, this.slotRequestMaxInterval, componentMainThreadExecutor);
    }
}

