/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobmaster.event.JobEvent;
import org.apache.flink.runtime.jobmaster.event.JobEventReplayHandler;
import org.apache.flink.runtime.jobmaster.event.JobEventStore;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEventManager {
    private static final Logger LOG = LoggerFactory.getLogger(JobEventManager.class);
    private final JobEventStore jobEventStore;
    private boolean replaying = false;
    private boolean running = false;

    public JobEventManager(JobEventStore store) {
        this.jobEventStore = Preconditions.checkNotNull(store);
    }

    public void start() throws Exception {
        if (!this.running) {
            this.jobEventStore.start();
            this.running = true;
        }
    }

    public void stop(boolean clear) {
        if (this.running) {
            this.jobEventStore.stop(clear);
            this.running = false;
        }
    }

    public void writeEvent(JobEvent event, boolean cutBlock) {
        Preconditions.checkState(this.running);
        this.jobEventStore.writeEvent(event, cutBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replay(JobEventReplayHandler replayHandler) {
        Preconditions.checkState(this.running);
        try {
            JobEvent event;
            this.replaying = true;
            replayHandler.startReplay();
            while ((event = this.jobEventStore.readEvent()) != null) {
                replayHandler.replayOneEvent(event);
            }
            replayHandler.finalizeReplay();
        }
        catch (Throwable throwable) {
            LOG.warn("Replay job event failed.", throwable);
            boolean bl = false;
            return bl;
        }
        finally {
            this.replaying = false;
        }
        return true;
    }

    public boolean hasJobEvents() throws Exception {
        return !this.jobEventStore.isEmpty();
    }

    @VisibleForTesting
    boolean isRunning() {
        return this.running;
    }
}

