/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmanager.ExecutionPlanStore;
import org.apache.flink.runtime.jobmanager.ExecutionPlanStoreWatcher;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.flink.shaded.curator5.org.apache.curator.utils.ZKPaths;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperExecutionPlanStoreWatcher
implements ExecutionPlanStoreWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperExecutionPlanStoreWatcher.class);
    private final PathChildrenCache pathCache;
    private ExecutionPlanStore.ExecutionPlanListener executionPlanListener;
    private volatile boolean running;

    public ZooKeeperExecutionPlanStoreWatcher(PathChildrenCache pathCache) {
        this.pathCache = Preconditions.checkNotNull(pathCache);
        this.pathCache.getListenable().addListener((Object)new ExecutionPlansPathCacheListener());
        this.running = false;
    }

    @Override
    public void start(ExecutionPlanStore.ExecutionPlanListener executionPlanListener) throws Exception {
        this.executionPlanListener = Preconditions.checkNotNull(executionPlanListener);
        this.running = true;
        this.pathCache.start();
    }

    @Override
    public void stop() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Stopping ZooKeeperExecutionPlanStoreWatcher ");
        this.pathCache.close();
    }

    private final class ExecutionPlansPathCacheListener
    implements PathChildrenCacheListener {
        private ExecutionPlansPathCacheListener() {
        }

        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
            if (LOG.isDebugEnabled()) {
                if (event.getData() != null) {
                    LOG.debug("Received {} event (path: {})", (Object)event.getType(), (Object)event.getData().getPath());
                } else {
                    LOG.debug("Received {} event", (Object)event.getType());
                }
            }
            switch (event.getType()) {
                case CHILD_ADDED: {
                    JobID jobId = this.fromEvent(event);
                    LOG.debug("Received CHILD_ADDED event notification for job {}", (Object)jobId);
                    ZooKeeperExecutionPlanStoreWatcher.this.executionPlanListener.onAddedExecutionPlan(jobId);
                    break;
                }
                case CHILD_UPDATED: {
                    break;
                }
                case CHILD_REMOVED: {
                    JobID jobId = this.fromEvent(event);
                    LOG.debug("Received CHILD_REMOVED event notification for job {}", (Object)jobId);
                    ZooKeeperExecutionPlanStoreWatcher.this.executionPlanListener.onRemovedExecutionPlan(jobId);
                    break;
                }
                case CONNECTION_SUSPENDED: {
                    LOG.warn("ZooKeeper connection SUSPENDING. Changes to the submitted job graphs are not monitored (temporarily).");
                    break;
                }
                case CONNECTION_LOST: {
                    LOG.warn("ZooKeeper connection LOST. Changes to the submitted job graphs are not monitored (permanently).");
                    break;
                }
                case CONNECTION_RECONNECTED: {
                    LOG.info("ZooKeeper connection RECONNECTED. Changes to the submitted job graphs are monitored again.");
                    break;
                }
                case INITIALIZED: {
                    LOG.info("ExecutionPlansPathCacheListener initialized");
                }
            }
        }

        private JobID fromEvent(PathChildrenCacheEvent event) {
            return JobID.fromHexString(ZKPaths.getNodeFromPath((String)event.getData().getPath()));
        }
    }
}

