/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.declare;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.asyncprocessing.declare.ContextVariable;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationChain;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationException;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationManager;
import org.apache.flink.runtime.asyncprocessing.declare.DeclaredVariable;
import org.apache.flink.runtime.asyncprocessing.declare.NamedBiFunction;
import org.apache.flink.runtime.asyncprocessing.declare.NamedConsumer;
import org.apache.flink.runtime.asyncprocessing.declare.NamedFunction;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public class DeclarationContext {
    private static final String AUTO_NAME_PREFIX = "F";
    private final DeclarationManager manager;

    public DeclarationContext(DeclarationManager manager) {
        this.manager = manager;
    }

    public <T> NamedConsumer<T> declare(String name, ThrowingConsumer<T, ? extends Exception> callback) throws DeclarationException {
        return this.manager.register(new NamedConsumer<T>(name, callback));
    }

    public <T, V> NamedFunction<T, V> declare(String name, FunctionWithException<T, V, ? extends Exception> callback) throws DeclarationException {
        return this.manager.register(new NamedFunction<T, V>(name, callback));
    }

    public <T, U, V> NamedBiFunction<T, U, V> declare(String name, BiFunctionWithException<T, U, V, ? extends Exception> callback) throws DeclarationException {
        return this.manager.register(new NamedBiFunction<T, U, V>(name, callback));
    }

    public <T> NamedConsumer<T> declare(ThrowingConsumer<T, ? extends Exception> callback) throws DeclarationException {
        return this.declare(this.manager.nextAssignedName(AUTO_NAME_PREFIX), callback);
    }

    public <T, V> NamedFunction<T, V> declare(FunctionWithException<T, V, ? extends Exception> callback) throws DeclarationException {
        return this.declare(this.manager.nextAssignedName(AUTO_NAME_PREFIX), callback);
    }

    public <T, U, V> NamedBiFunction<T, U, V> declare(BiFunctionWithException<T, U, V, ? extends Exception> callback) throws DeclarationException {
        return this.declare(this.manager.nextAssignedName(AUTO_NAME_PREFIX), callback);
    }

    public <T> DeclaredVariable<T> declareVariable(TypeSerializer<T> serializer, String name, @Nullable Supplier<T> initialValue) throws DeclarationException {
        return this.manager.registerVariable(serializer, name, initialValue);
    }

    public <T> ContextVariable<T> declareVariable(@Nullable Supplier<T> initializer) throws DeclarationException {
        return this.manager.registerVariable(initializer);
    }

    public <IN> DeclarationChain.DeclarationStage<IN> declareChain() throws DeclarationException {
        return new DeclarationChain(this).firstStage();
    }
}

