/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.jackson.JacksonMapperFactory;

public final class JsonRowSchemaConverter {
    private static final String PROPERTIES = "properties";
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String TYPE = "type";
    private static final String FORMAT = "format";
    private static final String CONTENT_ENCODING = "contentEncoding";
    private static final String ITEMS = "items";
    private static final String ADDITIONAL_ITEMS = "additionalItems";
    private static final String REF = "$ref";
    private static final String ALL_OF = "allOf";
    private static final String ANY_OF = "anyOf";
    private static final String NOT = "not";
    private static final String ONE_OF = "oneOf";
    private static final String DISALLOW = "disallow";
    private static final String EXTENDS = "extends";
    private static final String TYPE_NULL = "null";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_OBJECT = "object";
    private static final String TYPE_ARRAY = "array";
    private static final String TYPE_NUMBER = "number";
    private static final String TYPE_INTEGER = "integer";
    private static final String TYPE_STRING = "string";
    private static final String FORMAT_DATE = "date";
    private static final String FORMAT_TIME = "time";
    private static final String FORMAT_DATE_TIME = "date-time";
    private static final String CONTENT_ENCODING_BASE64 = "base64";

    private JsonRowSchemaConverter() {
    }

    public static <T> TypeInformation<T> convert(String jsonSchema) {
        JsonNode node;
        Preconditions.checkNotNull(jsonSchema, "JSON schema");
        ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();
        mapper.getFactory().enable(JsonParser.Feature.ALLOW_COMMENTS).enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
        try {
            node = mapper.readTree(jsonSchema);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON schema.", e);
        }
        return JsonRowSchemaConverter.convertType("<root>", node, node);
    }

    private static TypeInformation<?> convertType(String location, JsonNode node, JsonNode root) {
        Object types;
        HashSet<TypeInformation<Object>> typeSet = new HashSet<TypeInformation<Object>>();
        Optional<Object> ref = node.has(REF) && node.get(REF).isTextual() ? Optional.of(JsonRowSchemaConverter.resolveReference(node.get(REF).asText(), node, root)) : Optional.empty();
        if (node.has(TYPE)) {
            JsonNode typeNode = node.get(TYPE);
            ArrayList<String> types2 = new ArrayList<String>();
            if (typeNode.isArray()) {
                Iterator<JsonNode> elements = typeNode.elements();
                while (elements.hasNext()) {
                    types2.add(elements.next().asText());
                }
            } else if (typeNode.isTextual()) {
                types2.add(typeNode.asText());
            }
            Iterator iterator = types2.iterator();
            block19: while (iterator.hasNext()) {
                String type;
                switch (type = (String)iterator.next()) {
                    case "null": {
                        typeSet.add(Types.VOID);
                        continue block19;
                    }
                    case "boolean": {
                        typeSet.add(Types.BOOLEAN);
                        continue block19;
                    }
                    case "string": {
                        if (node.has(FORMAT)) {
                            typeSet.add(JsonRowSchemaConverter.convertStringFormat(location, node.get(FORMAT)));
                            continue block19;
                        }
                        if (node.has(CONTENT_ENCODING)) {
                            typeSet.add(JsonRowSchemaConverter.convertStringEncoding(location, node.get(CONTENT_ENCODING)));
                            continue block19;
                        }
                        typeSet.add(Types.STRING);
                        continue block19;
                    }
                    case "number": {
                        typeSet.add(Types.BIG_DEC);
                        continue block19;
                    }
                    case "integer": {
                        typeSet.add(Types.BIG_DEC);
                        continue block19;
                    }
                    case "object": {
                        typeSet.add(JsonRowSchemaConverter.convertObject(location, node, root));
                        continue block19;
                    }
                    case "array": {
                        typeSet.add(JsonRowSchemaConverter.convertArray(location, node, root));
                        continue block19;
                    }
                }
                throw new IllegalArgumentException("Unsupported type '" + node.get(TYPE).asText() + "' in node: " + location);
            }
        } else {
            ref.filter(r -> r.has(TYPE)).ifPresent(r -> typeSet.add(JsonRowSchemaConverter.convertType(node.get(REF).asText(), r, root)));
        }
        if (node.has(ONE_OF) && node.get(ONE_OF).isArray()) {
            types = JsonRowSchemaConverter.convertTypes(location + "/oneOf", node.get(ONE_OF), root);
            typeSet.addAll(Arrays.asList(types));
        } else if (ref.isPresent() && ((JsonNode)ref.get()).has(ONE_OF) && ((JsonNode)ref.get()).get(ONE_OF).isArray()) {
            types = JsonRowSchemaConverter.convertTypes(node.get(REF).asText() + "/oneOf", ((JsonNode)ref.get()).get(ONE_OF), root);
            typeSet.addAll(Arrays.asList(types));
        }
        if (node.has(ALL_OF) || node.has(ANY_OF) || node.has(NOT) || node.has(EXTENDS) || node.has(DISALLOW)) {
            throw new IllegalArgumentException("Union types are such as 'allOf', 'anyOf' etc. and extending are not supported yet.");
        }
        types = new ArrayList(typeSet);
        if (types.size() == 0) {
            throw new IllegalArgumentException("No type could be found in node:" + location);
        }
        if (types.size() > 2 || types.size() == 2 && !types.contains(Types.VOID)) {
            throw new IllegalArgumentException("Union types with more than just a null type are not supported yet.");
        }
        if (types.size() == 2 && types.get(0) == Types.VOID) {
            return (TypeInformation)types.get(1);
        }
        return (TypeInformation)types.get(0);
    }

    private static TypeInformation<Row> convertObject(String location, JsonNode node, JsonNode root) {
        if (!node.has(PROPERTIES)) {
            return Types.ROW(new TypeInformation[0]);
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("Invalid 'properties' property for object type in node: " + location);
        }
        JsonNode props = node.get(PROPERTIES);
        String[] names = new String[props.size()];
        TypeInformation[] types = new TypeInformation[props.size()];
        Iterator<Map.Entry<String, JsonNode>> fieldIter = props.fields();
        int i = 0;
        while (fieldIter.hasNext()) {
            Map.Entry<String, JsonNode> subNode = fieldIter.next();
            names[i] = subNode.getKey();
            types[i] = JsonRowSchemaConverter.convertType(location + "/" + subNode.getKey(), subNode.getValue(), root);
            ++i;
        }
        if (node.has(ADDITIONAL_PROPERTIES) && node.get(ADDITIONAL_PROPERTIES).isBoolean() && node.get(ADDITIONAL_PROPERTIES).asBoolean()) {
            throw new IllegalArgumentException("An object must not allow additional properties in node: " + location);
        }
        return Types.ROW_NAMED(names, types);
    }

    private static TypeInformation<?> convertArray(String location, JsonNode node, JsonNode root) {
        if (!node.has(ITEMS)) {
            throw new IllegalArgumentException("Arrays must specify an 'items' property in node: " + location);
        }
        JsonNode items = node.get(ITEMS);
        if (items.isObject()) {
            TypeInformation<?> elementType = JsonRowSchemaConverter.convertType(location + "/items", items, root);
            return Types.OBJECT_ARRAY(elementType);
        }
        if (items.isArray()) {
            TypeInformation<?>[] types = JsonRowSchemaConverter.convertTypes(location + "/items", items, root);
            if (node.has(ADDITIONAL_ITEMS) && node.get(ADDITIONAL_ITEMS).isBoolean() && node.get(ADDITIONAL_ITEMS).asBoolean()) {
                throw new IllegalArgumentException("An array tuple must not allow additional items in node: " + location);
            }
            return Types.ROW(types);
        }
        throw new IllegalArgumentException("Invalid type for 'items' property in node: " + location);
    }

    private static TypeInformation<?> convertStringFormat(String location, JsonNode node) {
        if (!node.isTextual()) {
            throw new IllegalArgumentException("Invalid 'format' property in node: " + location);
        }
        switch (node.asText()) {
            case "date": {
                return Types.SQL_DATE;
            }
            case "time": {
                return Types.SQL_TIME;
            }
            case "date-time": {
                return Types.SQL_TIMESTAMP;
            }
        }
        return Types.STRING;
    }

    private static TypeInformation<?> convertStringEncoding(String location, JsonNode node) {
        if (!node.isTextual()) {
            throw new IllegalArgumentException("Invalid 'contentEncoding' property in node: " + location);
        }
        switch (node.asText()) {
            case "base64": {
                return Types.PRIMITIVE_ARRAY(Types.BYTE);
            }
        }
        throw new IllegalArgumentException("Invalid encoding '" + node.asText() + "' in node: " + location);
    }

    private static JsonNode resolveReference(String ref, JsonNode origin, JsonNode root) {
        if (!ref.startsWith("#")) {
            throw new IllegalArgumentException("Only JSON schemes with simple references (one indirection in the same document) are supported yet. But was: " + ref);
        }
        String path = ref.substring(1);
        JsonNode foundNode = root.at(path);
        if (foundNode.isMissingNode()) {
            throw new IllegalArgumentException("Could not find reference: " + ref);
        }
        if (foundNode == origin) {
            throw new IllegalArgumentException("Cyclic references are not supported:" + ref);
        }
        return foundNode;
    }

    private static TypeInformation<?>[] convertTypes(String location, JsonNode arrayNode, JsonNode root) {
        TypeInformation[] types = new TypeInformation[arrayNode.size()];
        Iterator<JsonNode> elements = arrayNode.elements();
        int i = 0;
        while (elements.hasNext()) {
            TypeInformation<?> elementType;
            types[i] = elementType = JsonRowSchemaConverter.convertType(location + "[" + i + "]", elements.next(), root);
            ++i;
        }
        return types;
    }
}

