/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.AbstractJsonDeserializationSchema;
import org.apache.flink.formats.json.JsonToRowDataConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@Internal
public class JsonRowDataDeserializationSchema
extends AbstractJsonDeserializationSchema {
    private static final long serialVersionUID = 1L;
    private final JsonToRowDataConverters.JsonToRowDataConverter runtimeConverter;

    public JsonRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean failOnMissingField, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        super(rowType, resultTypeInfo, failOnMissingField, ignoreParseErrors, timestampFormat);
        this.runtimeConverter = new JsonToRowDataConverters(failOnMissingField, ignoreParseErrors, timestampFormat).createConverter(Preconditions.checkNotNull(rowType));
    }

    @Override
    public RowData deserialize(@Nullable byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        try {
            return this.convertToRowData(this.deserializeToJsonNode(message));
        }
        catch (Throwable t) {
            if (this.ignoreParseErrors) {
                return null;
            }
            throw new IOException(String.format("Failed to deserialize JSON '%s'.", new String(message)), t);
        }
    }

    public JsonNode deserializeToJsonNode(byte[] message) throws IOException {
        return this.objectMapper.readTree(message);
    }

    public RowData convertToRowData(JsonNode message) {
        return (RowData)this.runtimeConverter.convert(message);
    }
}

