/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.configuration.YamlParserUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public final class DelegatingConfiguration
extends Configuration {
    private static final long serialVersionUID = 1L;
    private final Configuration backingConfig;
    @Nonnull
    private String prefix;

    public DelegatingConfiguration() {
        this(new Configuration(), "");
    }

    public DelegatingConfiguration(Configuration backingConfig, String prefix) {
        this.backingConfig = Preconditions.checkNotNull(backingConfig);
        this.prefix = Preconditions.checkNotNull(prefix, "The 'prefix' attribute mustn't be null.");
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.backingConfig.getString(this.prefix + key, defaultValue);
    }

    @Override
    public void setString(String key, String value) {
        this.backingConfig.setString(this.prefix + key, value);
    }

    @Override
    public byte[] getBytes(String key, byte[] defaultValue) {
        return this.backingConfig.getBytes(this.prefix + key, defaultValue);
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        this.backingConfig.setBytes(this.prefix + key, bytes);
    }

    @Override
    public String getValue(ConfigOption<?> configOption) {
        return this.backingConfig.getValue(DelegatingConfiguration.prefixOption(configOption, this.prefix));
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> enumClass, ConfigOption<String> configOption) {
        return this.backingConfig.getEnum(enumClass, DelegatingConfiguration.prefixOption(configOption, this.prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAllToProperties(Properties props) {
        HashMap<String, Object> hashMap = this.backingConfig.confData;
        synchronized (hashMap) {
            for (Map.Entry<String, Object> entry : this.backingConfig.confData.entrySet()) {
                if (!entry.getKey().startsWith(this.prefix)) continue;
                String keyWithoutPrefix = entry.getKey().substring(this.prefix.length(), entry.getKey().length());
                props.put(keyWithoutPrefix, entry.getValue());
            }
        }
    }

    @Override
    public void addAll(Configuration other) {
        this.addAll(other, "");
    }

    @Override
    public void addAll(Configuration other, String prefix) {
        this.backingConfig.addAll(other, this.prefix + prefix);
    }

    @Override
    public String toString() {
        return this.backingConfig.toString();
    }

    @Override
    public Set<String> keySet() {
        if (this.prefix.isEmpty()) {
            return this.backingConfig.keySet();
        }
        HashSet<String> set = new HashSet<String>();
        int prefixLen = this.prefix.length();
        for (String key : this.backingConfig.keySet()) {
            if (!key.startsWith(this.prefix)) continue;
            set.add(key.substring(prefixLen));
        }
        return set;
    }

    @Override
    public Configuration clone() {
        return new DelegatingConfiguration(this.backingConfig.clone(), this.prefix);
    }

    @Override
    public Map<String, String> toMap() {
        Map<String, String> map = this.backingConfig.toMap();
        HashMap<String, String> prefixed = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(this.prefix)) continue;
            String keyWithoutPrefix = entry.getKey().substring(this.prefix.length());
            prefixed.put(keyWithoutPrefix, entry.getValue());
        }
        return prefixed;
    }

    @Override
    public Map<String, String> toFileWritableMap() {
        Map<String, String> map = this.backingConfig.toFileWritableMap();
        HashMap<String, String> prefixed = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(this.prefix)) continue;
            String keyWithoutPrefix = entry.getKey().substring(this.prefix.length());
            prefixed.put(keyWithoutPrefix, YamlParserUtils.toYAMLString(entry.getValue()));
        }
        return prefixed;
    }

    @Override
    public <T> boolean removeConfig(ConfigOption<T> configOption) {
        return this.backingConfig.removeConfig(DelegatingConfiguration.prefixOption(configOption, this.prefix));
    }

    @Override
    public boolean removeKey(String key) {
        return this.backingConfig.removeKey(this.prefix + key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.backingConfig.containsKey(this.prefix + key);
    }

    @Override
    public boolean contains(ConfigOption<?> configOption) {
        return this.backingConfig.contains(DelegatingConfiguration.prefixOption(configOption, this.prefix));
    }

    @Override
    public <T> T get(ConfigOption<T> option) {
        return this.backingConfig.get(DelegatingConfiguration.prefixOption(option, this.prefix));
    }

    @Override
    public <T> T get(ConfigOption<T> configOption, T overrideDefault) {
        return this.backingConfig.get(DelegatingConfiguration.prefixOption(configOption, this.prefix), overrideDefault);
    }

    @Override
    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        return this.backingConfig.getOptional(DelegatingConfiguration.prefixOption(option, this.prefix));
    }

    @Override
    public <T> Configuration set(ConfigOption<T> option, T value) {
        this.backingConfig.set((ConfigOption)DelegatingConfiguration.prefixOption(option, this.prefix), (Object)value);
        return this;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.prefix = Preconditions.checkNotNull(in.readUTF());
        this.backingConfig.read(in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeUTF(this.prefix);
        this.backingConfig.write(out);
    }

    @Override
    public int hashCode() {
        return this.prefix.hashCode() ^ this.backingConfig.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DelegatingConfiguration) {
            DelegatingConfiguration other = (DelegatingConfiguration)obj;
            return this.prefix.equals(other.prefix) && this.backingConfig.equals(other.backingConfig);
        }
        return false;
    }

    private static <T> ConfigOption<T> prefixOption(ConfigOption<T> option, String prefix) {
        List<FallbackKey> deprecatedKeys;
        String key = prefix + option.key();
        if (option.hasFallbackKeys()) {
            deprecatedKeys = new ArrayList();
            for (FallbackKey dk : option.fallbackKeys()) {
                deprecatedKeys.add(FallbackKey.createDeprecatedKey(prefix + dk.getKey()));
            }
        } else {
            deprecatedKeys = Collections.emptyList();
        }
        FallbackKey[] deprecated = deprecatedKeys.toArray(new FallbackKey[0]);
        return new ConfigOption<T>(key, option.getClazz(), option.description(), option.defaultValue(), option.isList(), deprecated);
    }
}

