/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state.v2;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.SerializerFactory;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.state.v2.StateSerializerReference;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Experimental
public class MapStateDescriptor<UK, UV>
extends StateDescriptor<UV> {
    @Nonnull
    private final StateSerializerReference<UK> userKeySerializer;

    public MapStateDescriptor(@Nonnull String stateId, @Nonnull TypeInformation<UK> userKeyTypeInfo, @Nonnull TypeInformation<UV> userValueTypeInfo) {
        super(stateId, userValueTypeInfo);
        this.userKeySerializer = new StateSerializerReference<UK>(userKeyTypeInfo);
    }

    public MapStateDescriptor(@Nonnull String stateId, @Nonnull TypeSerializer<UK> userKeySerializer, @Nonnull TypeSerializer<UV> userValueSerializer) {
        super(stateId, userValueSerializer);
        this.userKeySerializer = new StateSerializerReference<UK>(userKeySerializer);
    }

    public MapStateDescriptor(String name, Class<UK> keyClass, Class<UV> valueClass) {
        super(name, valueClass);
        this.userKeySerializer = new StateSerializerReference<UK>(keyClass);
    }

    @Nonnull
    public TypeSerializer<UK> getUserKeySerializer() {
        TypeSerializer serializer = (TypeSerializer)this.userKeySerializer.get();
        if (serializer != null) {
            return serializer.duplicate();
        }
        throw new IllegalStateException("Serializer not yet initialized.");
    }

    @Nullable
    @Internal
    public TypeInformation<UK> getUserKeyTypeInformation() {
        return this.userKeySerializer.getTypeInformation();
    }

    @Override
    public boolean isSerializerInitialized() {
        return super.isSerializerInitialized() && this.userKeySerializer.isInitialized();
    }

    @Override
    public void initializeSerializerUnlessSet(ExecutionConfig executionConfig) {
        super.initializeSerializerUnlessSet(executionConfig);
        this.userKeySerializer.initializeUnlessSet(executionConfig);
    }

    @Override
    public void initializeSerializerUnlessSet(SerializerFactory serializerFactory) {
        super.initializeSerializerUnlessSet(serializerFactory);
        this.userKeySerializer.initializeUnlessSet(serializerFactory);
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.MAP;
    }
}

