/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.client.cli.ProgramOptionsUtils;
import org.apache.flink.client.deployment.application.ApplicationDispatcherLeaderProcessFactoryFactory;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.SessionDispatcherFactory;
import org.apache.flink.runtime.dispatcher.runner.DefaultDispatcherRunnerFactory;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.rest.JobRestEndpointFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class ApplicationClusterEntryPoint
extends ClusterEntrypoint {
    private final PackagedProgram program;
    private final ResourceManagerFactory<?> resourceManagerFactory;

    protected ApplicationClusterEntryPoint(Configuration configuration, PackagedProgram program, ResourceManagerFactory<?> resourceManagerFactory) {
        super(configuration);
        this.program = Preconditions.checkNotNull(program);
        this.resourceManagerFactory = Preconditions.checkNotNull(resourceManagerFactory);
    }

    @Override
    protected DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration configuration) {
        return new DefaultDispatcherResourceManagerComponentFactory(new DefaultDispatcherRunnerFactory(ApplicationDispatcherLeaderProcessFactoryFactory.create(configuration, SessionDispatcherFactory.INSTANCE, this.program)), this.resourceManagerFactory, JobRestEndpointFactory.INSTANCE);
    }

    @Override
    protected ExecutionGraphInfoStore createSerializableExecutionGraphStore(Configuration configuration, ScheduledExecutor scheduledExecutor) {
        return new MemoryExecutionGraphInfoStore();
    }

    protected static void configureExecution(Configuration configuration, PackagedProgram program) throws Exception {
        configuration.set((ConfigOption)DeploymentOptions.TARGET, "embedded");
        ConfigUtils.encodeCollectionToConfig(configuration, PipelineOptions.JARS, program.getJobJarAndDependencies(), URL::toString);
        ConfigUtils.encodeCollectionToConfig(configuration, PipelineOptions.CLASSPATHS, ApplicationClusterEntryPoint.getClasspath(configuration, program), URL::toString);
        if (PackagedProgramUtils.isPython(program.getMainClassName()).booleanValue()) {
            ProgramOptionsUtils.configurePythonExecution(configuration, program);
        }
    }

    private static List<URL> getClasspath(Configuration configuration, PackagedProgram program) throws MalformedURLException {
        List<URL> classpath = ConfigUtils.decodeListFromConfig(configuration, PipelineOptions.CLASSPATHS, URL::new);
        classpath.addAll(program.getClasspaths());
        return Collections.unmodifiableList(classpath.stream().distinct().collect(Collectors.toList()));
    }

    @Override
    protected void cleanupDirectories(ClusterEntrypoint.ShutdownBehaviour shutdownBehaviour) throws IOException {
        this.program.close();
        super.cleanupDirectories(shutdownBehaviour);
    }
}

