/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.operation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public enum OperationStatus {
    INITIALIZED(false),
    PENDING(false),
    RUNNING(false),
    FINISHED(true),
    CANCELED(true),
    CLOSED(true),
    ERROR(true),
    TIMEOUT(true);

    private final boolean isTerminalStatus;

    private OperationStatus(boolean isTerminalStatus) {
        this.isTerminalStatus = isTerminalStatus;
    }

    public static boolean isValidStatusTransition(OperationStatus fromStatus, OperationStatus toStatus) {
        return OperationStatus.toOperationStatusSet(fromStatus).contains((Object)toStatus);
    }

    public boolean isTerminalStatus() {
        return this.isTerminalStatus;
    }

    private static Set<OperationStatus> toOperationStatusSet(OperationStatus fromStatus) {
        switch (fromStatus) {
            case INITIALIZED: {
                return new HashSet<OperationStatus>(Arrays.asList(PENDING, CANCELED, CLOSED, TIMEOUT, ERROR));
            }
            case PENDING: {
                return new HashSet<OperationStatus>(Arrays.asList(RUNNING, CANCELED, CLOSED, TIMEOUT, ERROR));
            }
            case RUNNING: {
                return new HashSet<OperationStatus>(Arrays.asList(FINISHED, CANCELED, CLOSED, TIMEOUT, ERROR));
            }
            case FINISHED: 
            case CANCELED: 
            case TIMEOUT: 
            case ERROR: {
                return Collections.singleton(CLOSED);
            }
            case CLOSED: {
                return Collections.emptySet();
            }
        }
        throw new IllegalArgumentException("Unknown from status: " + (Object)((Object)fromStatus));
    }
}

