/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;

class UserFacingMapState<K, V>
implements MapState<K, V> {
    private final MapState<K, V> originalState;
    private final Map<K, V> emptyState = Collections.emptyMap();

    UserFacingMapState(MapState<K, V> originalState) {
        this.originalState = originalState;
    }

    @Override
    public V get(K key) throws Exception {
        return this.originalState.get(key);
    }

    @Override
    public void put(K key, V value) throws Exception {
        this.originalState.put(key, value);
    }

    @Override
    public void putAll(Map<K, V> value) throws Exception {
        this.originalState.putAll(value);
    }

    @Override
    public void clear() {
        this.originalState.clear();
    }

    @Override
    public void remove(K key) throws Exception {
        this.originalState.remove(key);
    }

    @Override
    public boolean contains(K key) throws Exception {
        return this.originalState.contains(key);
    }

    @Override
    public Iterable<Map.Entry<K, V>> entries() throws Exception {
        Iterable<Map.Entry<K, V>> original = this.originalState.entries();
        return original != null ? original : this.emptyState.entrySet();
    }

    @Override
    public Iterable<K> keys() throws Exception {
        Iterable<K> original = this.originalState.keys();
        return original != null ? original : this.emptyState.keySet();
    }

    @Override
    public Iterable<V> values() throws Exception {
        Iterable<V> original = this.originalState.values();
        return original != null ? original : this.emptyState.values();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() throws Exception {
        Iterator<Map.Entry<K, V>> original = this.originalState.iterator();
        return original != null ? original : this.emptyState.entrySet().iterator();
    }

    @Override
    public boolean isEmpty() throws Exception {
        return this.originalState.isEmpty();
    }
}

