/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.forwardgroup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class ForwardGroup {
    private int parallelism = -1;
    private int maxParallelism = -1;
    private final Set<JobVertexID> jobVertexIds = new HashSet<JobVertexID>();

    public ForwardGroup(Set<JobVertex> jobVertices) {
        Set configuredMaxParallelisms;
        Preconditions.checkNotNull(jobVertices);
        Set configuredParallelisms = jobVertices.stream().filter(jobVertex -> {
            this.jobVertexIds.add(jobVertex.getID());
            return jobVertex.getParallelism() > 0;
        }).map(JobVertex::getParallelism).collect(Collectors.toSet());
        Preconditions.checkState(configuredParallelisms.size() <= 1);
        if (configuredParallelisms.size() == 1) {
            this.parallelism = (Integer)configuredParallelisms.iterator().next();
        }
        if (!(configuredMaxParallelisms = jobVertices.stream().map(JobVertex::getMaxParallelism).filter(val -> val > 0).collect(Collectors.toSet())).isEmpty()) {
            this.maxParallelism = (Integer)Collections.min(configuredMaxParallelisms);
            Preconditions.checkState(this.parallelism == -1 || this.maxParallelism >= this.parallelism, "There is a job vertex in the forward group whose maximum parallelism is smaller than the group's parallelism");
        }
    }

    public void setParallelism(int parallelism) {
        Preconditions.checkState(this.parallelism == -1);
        this.parallelism = parallelism;
    }

    public boolean isParallelismDecided() {
        return this.parallelism > 0;
    }

    public int getParallelism() {
        Preconditions.checkState(this.isParallelismDecided());
        return this.parallelism;
    }

    public boolean isMaxParallelismDecided() {
        return this.maxParallelism > 0;
    }

    public int getMaxParallelism() {
        Preconditions.checkState(this.isMaxParallelismDecided());
        return this.maxParallelism;
    }

    public int size() {
        return this.jobVertexIds.size();
    }

    public Set<JobVertexID> getJobVertexIds() {
        return this.jobVertexIds;
    }
}

