/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils.print;

import com.ibm.icu.lang.UCharacter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;

@Internal
public final class TableauStyle
implements PrintStyle {
    private static final String ROW_KIND_COLUMN = "op";
    private static final String COLUMN_TRUNCATED_FLAG = "...";
    private final RowDataToStringConverter converter;
    private final int maxColumnWidth;
    private final boolean printNullAsEmpty;
    private final boolean printRowKind;
    private int[] columnWidths;
    private String[] columnNames;

    TableauStyle(ResolvedSchema resolvedSchema, RowDataToStringConverter converter, int[] columnWidths, int maxColumnWidth, boolean printNullAsEmpty, boolean printRowKind) {
        this.converter = converter;
        this.columnWidths = columnWidths;
        this.maxColumnWidth = maxColumnWidth;
        this.printNullAsEmpty = printNullAsEmpty;
        this.printRowKind = printRowKind;
        this.columnNames = printRowKind ? (String[])Stream.concat(Stream.of(ROW_KIND_COLUMN), resolvedSchema.getColumnNames().stream()).toArray(String[]::new) : resolvedSchema.getColumnNames().toArray(new String[0]);
    }

    @Nullable
    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    @Override
    public void print(Iterator<RowData> it, PrintWriter printWriter) {
        if (!it.hasNext()) {
            this.printEmptyResult(it, printWriter);
            return;
        }
        long numRows = this.printTable(it, printWriter);
        this.printFooter(printWriter, numRows);
    }

    public void printEmptyResult(Iterator<RowData> it, PrintWriter printWriter) {
        printWriter.println("Empty set");
        printWriter.flush();
    }

    public long printTable(Iterator<RowData> it, PrintWriter printWriter) {
        if (this.columnWidths == null) {
            ArrayList<RowData> rows = new ArrayList<RowData>();
            ArrayList<String[]> content = new ArrayList<String[]>();
            content.add(this.columnNames);
            while (it.hasNext()) {
                RowData row = it.next();
                rows.add(row);
                content.add(this.rowFieldsToString(row));
            }
            this.inferColumnWidth(content);
            it = rows.iterator();
        }
        this.printBorderLine(printWriter);
        this.printColumnNamesTableauRow(printWriter);
        this.printBorderLine(printWriter);
        long numRows = 0L;
        while (it.hasNext()) {
            String[] cols = this.rowFieldsToString(it.next());
            this.printTableauRow(cols, printWriter);
            ++numRows;
        }
        this.printBorderLine(printWriter);
        return numRows;
    }

    public void printFooter(PrintWriter printWriter, long numRows) {
        String rowTerm = numRows > 1L ? "rows" : "row";
        printWriter.println(numRows + " " + rowTerm + " in set");
        printWriter.flush();
    }

    public void inferColumnWidth(List<String[]> rowData) {
        if (this.columnWidths != null) {
            throw new IllegalStateException("Column widths have already been initialized.");
        }
        this.columnWidths = TableauStyle.columnWidthsByContent(this.columnNames, rowData, this.maxColumnWidth);
    }

    public String[] rowFieldsToString(RowData row) {
        int len = this.printRowKind ? row.getArity() + 1 : row.getArity();
        String[] result = new String[len];
        int offset = this.printRowKind ? 1 : 0;
        String[] conversionResult = this.converter.convert(row);
        if (this.printRowKind) {
            result[0] = row.getRowKind().shortString();
        }
        for (int i = 0; i < row.getArity(); ++i) {
            result[i + offset] = row.isNullAt(i) && this.printNullAsEmpty ? "" : conversionResult[i];
        }
        return result;
    }

    public void printColumnNamesTableauRow(PrintWriter printWriter) {
        this.printTableauRow(this.columnNames, printWriter);
    }

    public void printTableauRow(String[] cols, PrintWriter printWriter) {
        if (this.columnWidths == null) {
            this.columnWidths = TableauStyle.columnWidthsByContent(this.columnNames, Collections.singletonList(cols), this.maxColumnWidth);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        int idx = 0;
        for (String col : cols) {
            sb.append(" ");
            int displayWidth = TableauStyle.getStringDisplayWidth(col);
            if (displayWidth <= this.columnWidths[idx]) {
                sb.append(EncodingUtils.repeat(' ', this.columnWidths[idx] - displayWidth));
                sb.append(col);
            } else {
                sb.append(TableauStyle.truncateString(col, this.columnWidths[idx] - COLUMN_TRUNCATED_FLAG.length()));
                sb.append(COLUMN_TRUNCATED_FLAG);
            }
            sb.append(" |");
            ++idx;
        }
        printWriter.println(sb);
        printWriter.flush();
    }

    public void printBorderLine(PrintWriter printWriter) {
        if (this.columnWidths == null) {
            throw new IllegalStateException("Column widths should be initialized before printing a border line");
        }
        printWriter.append("+");
        for (int width : this.columnWidths) {
            printWriter.append(EncodingUtils.repeat('-', width + 1));
            printWriter.append("-+");
        }
        printWriter.println();
    }

    static int[] columnWidthsByType(List<Column> columns, int maxColumnWidth, boolean printNullAsEmpty, boolean printRowKind) {
        int[] colWidths = columns.stream().mapToInt(col -> col.getName().length()).toArray();
        for (int i = 0; i < columns.size(); ++i) {
            int len;
            LogicalType type = columns.get(i).getDataType().getLogicalType();
            switch (type.getTypeRoot()) {
                case TINYINT: {
                    len = 4;
                    break;
                }
                case SMALLINT: {
                    len = 6;
                    break;
                }
                case INTEGER: {
                    len = 11;
                    break;
                }
                case BIGINT: {
                    len = 20;
                    break;
                }
                case DECIMAL: {
                    len = ((DecimalType)type).getPrecision() + 2;
                    break;
                }
                case BOOLEAN: {
                    len = 5;
                    break;
                }
                case DATE: {
                    len = 10;
                    break;
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    int precision = ((TimeType)type).getPrecision();
                    len = precision == 0 ? 8 : precision + 9;
                    break;
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    int precision = ((TimestampType)type).getPrecision();
                    len = TableauStyle.timestampTypeColumnWidth(precision);
                    break;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    int precision = ((LocalZonedTimestampType)type).getPrecision();
                    len = TableauStyle.timestampTypeColumnWidth(precision);
                    break;
                }
                default: {
                    len = maxColumnWidth;
                }
            }
            len = printNullAsEmpty ? len : Math.max(len, "<NULL>".length());
            colWidths[i] = Math.max(colWidths[i], len);
        }
        if (printRowKind) {
            int[] ret = new int[columns.size() + 1];
            ret[0] = ROW_KIND_COLUMN.length();
            System.arraycopy(colWidths, 0, ret, 1, columns.size());
            return ret;
        }
        return colWidths;
    }

    private static int[] columnWidthsByContent(String[] columnNames, List<String[]> rows, int maxColumnWidth) {
        int[] colWidths = Stream.of(columnNames).mapToInt(String::length).toArray();
        for (String[] row : rows) {
            for (int i = 0; i < row.length; ++i) {
                colWidths[i] = Math.max(colWidths[i], TableauStyle.getStringDisplayWidth(row[i]));
            }
        }
        for (int i = 0; i < colWidths.length; ++i) {
            colWidths[i] = Math.min(colWidths[i], maxColumnWidth);
        }
        return colWidths;
    }

    private static int timestampTypeColumnWidth(int precision) {
        int base = 19;
        if (precision == 0) {
            return base;
        }
        if (precision <= 3) {
            return base + 4;
        }
        if (precision <= 6) {
            return base + 7;
        }
        return base + 10;
    }

    static int getStringDisplayWidth(String str) {
        int numOfFullWidthCh = (int)str.codePoints().filter(TableauStyle::isFullWidth).count();
        return str.length() + numOfFullWidthCh;
    }

    static boolean isFullWidth(int codePoint) {
        int value = UCharacter.getIntPropertyValue((int)codePoint, (int)4100);
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return false;
            }
            case 3: 
            case 5: {
                return true;
            }
        }
        throw new RuntimeException("unknown UProperty.EAST_ASIAN_WIDTH: " + value);
    }

    private static String truncateString(String col, int targetWidth) {
        String substring;
        int lackedWidth;
        int i;
        int passedWidth = 0;
        for (i = 0; i < col.length(); ++i) {
            passedWidth = TableauStyle.isFullWidth(Character.codePointAt(col, i)) ? (passedWidth += 2) : ++passedWidth;
            if (passedWidth > targetWidth) break;
        }
        if ((lackedWidth = targetWidth - TableauStyle.getStringDisplayWidth(substring = col.substring(0, i))) > 0) {
            substring = EncodingUtils.repeat(' ', lackedWidth) + substring;
        }
        return substring;
    }
}

