/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.resourcemanager.AbstractResourceManagerHandler;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.cluster.ProfilingRequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.concurrent.FutureUtils;

public class TaskManagerProfilingHandler
extends AbstractResourceManagerHandler<RestfulGateway, ProfilingRequestBody, ProfilingInfo, TaskManagerMessageParameters> {
    private final long maxDurationInSeconds;

    public TaskManagerProfilingHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<ProfilingRequestBody, ProfilingInfo, TaskManagerMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, Configuration configuration) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
        this.maxDurationInSeconds = configuration.get(RestOptions.MAX_PROFILING_DURATION).getSeconds();
    }

    @Override
    protected CompletableFuture<ProfilingInfo> handleRequest(@Nonnull HandlerRequest<ProfilingRequestBody> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        ProfilingRequestBody profilingRequest = request.getRequestBody();
        int duration = profilingRequest.getDuration();
        if (duration <= 0 || (long)duration > this.maxDurationInSeconds) {
            return FutureUtils.completedExceptionally(new IllegalArgumentException(String.format("`duration` must be set between (0s, %ds].", this.maxDurationInSeconds)));
        }
        ResourceID taskManagerId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        return gateway.requestProfiling(taskManagerId, duration, profilingRequest.getMode(), this.getTimeout());
    }
}

