/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractAccessExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.AggregatedTaskDetailsInfo;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.JobVertexTaskManagersInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.StatusDurationUtils;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class JobVertexTaskManagersHandler
extends AbstractAccessExecutionGraphHandler<JobVertexTaskManagersInfo, JobVertexMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    private MetricFetcher metricFetcher;

    public JobVertexTaskManagersHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVertexTaskManagersInfo, JobVertexMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher metricFetcher) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = Preconditions.checkNotNull(metricFetcher);
    }

    @Override
    protected JobVertexTaskManagersInfo handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexID = (JobVertexID)request.getPathParameter(JobVertexIdPathParameter.class);
        AccessExecutionJobVertex jobVertex = executionGraph.getJobVertex(jobVertexID);
        if (jobVertex == null) {
            throw new NotFoundException(String.format("JobVertex %s not found", jobVertexID));
        }
        return JobVertexTaskManagersHandler.createJobVertexTaskManagersInfo(jobVertex, jobID, this.metricFetcher);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        Collection<? extends AccessExecutionJobVertex> vertices = graph.getAllVertices().values();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(vertices.size());
        for (AccessExecutionJobVertex accessExecutionJobVertex : vertices) {
            JobVertexTaskManagersInfo json = JobVertexTaskManagersHandler.createJobVertexTaskManagersInfo(accessExecutionJobVertex, graph.getJobID(), null);
            String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
            archive.add(new ArchivedJson(path, json));
        }
        return archive;
    }

    private static JobVertexTaskManagersInfo createJobVertexTaskManagersInfo(AccessExecutionJobVertex jobVertex, JobID jobID, @Nullable MetricFetcher metricFetcher) {
        HashMap<TaskManagerLocation, List> taskManagerExecutions = new HashMap<TaskManagerLocation, List>();
        HashSet<AccessExecution> representativeExecutions = new HashSet<AccessExecution>();
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            AccessExecution representativeAttempt = vertex.getCurrentExecutionAttempt();
            representativeExecutions.add(representativeAttempt);
            for (AccessExecution execution : vertex.getCurrentExecutions()) {
                TaskManagerLocation location = execution.getAssignedResourceLocation();
                List executions = taskManagerExecutions.computeIfAbsent(location, ignored -> new ArrayList());
                executions.add(execution);
            }
        }
        long now = System.currentTimeMillis();
        ArrayList<JobVertexTaskManagersInfo.TaskManagersInfo> taskManagersInfoList = new ArrayList<JobVertexTaskManagersInfo.TaskManagersInfo>(4);
        for (Map.Entry entry : taskManagerExecutions.entrySet()) {
            long duration;
            TaskManagerLocation location = (TaskManagerLocation)entry.getKey();
            String host = location == null ? "(unassigned)" : location.getHostname() + ':' + location.dataPort();
            String endpoint = location == null ? "(unassigned)" : location.getEndpoint();
            String taskmanagerId = location == null ? "(unassigned)" : location.getResourceID().toString();
            List executions = (List)entry.getValue();
            ArrayList<IOMetricsInfo> ioMetricsInfos = new ArrayList<IOMetricsInfo>();
            List<Map<ExecutionState, Long>> status = executions.stream().map(StatusDurationUtils::getExecutionStateDuration).collect(Collectors.toList());
            int[] executionsPerState = new int[ExecutionState.values().length];
            int[] tasksPerState = new int[ExecutionState.values().length];
            long startTime = Long.MAX_VALUE;
            long endTime = 0L;
            boolean allFinished = true;
            MutableIOMetrics counts = new MutableIOMetrics();
            int representativeAttemptsCount = 0;
            for (AccessExecution execution : executions) {
                long started;
                ExecutionState state = execution.getState();
                int n = state.ordinal();
                executionsPerState[n] = executionsPerState[n] + 1;
                if (representativeExecutions.contains(execution)) {
                    int n2 = state.ordinal();
                    tasksPerState[n2] = tasksPerState[n2] + 1;
                    ++representativeAttemptsCount;
                }
                if ((started = execution.getStateTimestamp(ExecutionState.DEPLOYING)) > 0L) {
                    startTime = Math.min(startTime, started);
                }
                allFinished &= state.isTerminal();
                endTime = Math.max(endTime, execution.getStateTimestamp(state));
                counts.addIOMetrics(execution, metricFetcher, jobID.toString(), jobVertex.getJobVertexId().toString());
                MutableIOMetrics current = new MutableIOMetrics();
                current.addIOMetrics(execution, metricFetcher, jobID.toString(), jobVertex.getJobVertexId().toString());
                ioMetricsInfos.add(new IOMetricsInfo(current.getNumBytesIn(), current.isNumBytesInComplete(), current.getNumBytesOut(), current.isNumBytesOutComplete(), current.getNumRecordsIn(), current.isNumRecordsInComplete(), current.getNumRecordsOut(), current.isNumRecordsOutComplete(), current.getAccumulateBackPressuredTime(), current.getAccumulateIdleTime(), current.getAccumulateBusyTime()));
            }
            if (startTime < Long.MAX_VALUE) {
                if (allFinished) {
                    duration = endTime - startTime;
                } else {
                    endTime = -1L;
                    duration = now - startTime;
                }
            } else {
                startTime = -1L;
                endTime = -1L;
                duration = -1L;
            }
            ExecutionState jobVertexState = ExecutionJobVertex.getAggregateJobVertexState(tasksPerState, representativeAttemptsCount);
            IOMetricsInfo jobVertexMetrics = new IOMetricsInfo(counts.getNumBytesIn(), counts.isNumBytesInComplete(), counts.getNumBytesOut(), counts.isNumBytesOutComplete(), counts.getNumRecordsIn(), counts.isNumRecordsInComplete(), counts.getNumRecordsOut(), counts.isNumRecordsOutComplete(), counts.getAccumulateBackPressuredTime(), counts.getAccumulateIdleTime(), counts.getAccumulateBusyTime());
            HashMap<ExecutionState, Integer> statusCounts = CollectionUtil.newHashMapWithExpectedSize(ExecutionState.values().length);
            for (ExecutionState state : ExecutionState.values()) {
                statusCounts.put(state, executionsPerState[state.ordinal()]);
            }
            taskManagersInfoList.add(new JobVertexTaskManagersInfo.TaskManagersInfo(host, endpoint, jobVertexState, startTime, endTime, duration, jobVertexMetrics, statusCounts, taskmanagerId, AggregatedTaskDetailsInfo.create(ioMetricsInfos, status)));
        }
        return new JobVertexTaskManagersInfo(jobVertex.getJobVertexId(), jobVertex.getName(), now, taskManagersInfoList);
    }
}

