/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class IgnoreShutdownRejectedExecutionHandler
implements RejectedExecutionHandler {
    @Nullable
    private final Logger logger;

    public IgnoreShutdownRejectedExecutionHandler() {
        this(null);
    }

    public IgnoreShutdownRejectedExecutionHandler(@Nullable Logger logger) {
        this.logger = logger;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (executor.isShutdown()) {
            if (this.logger != null) {
                this.logger.debug("Execution is rejected because shutdown is in progress");
            }
        } else {
            throw new RejectedExecutionException();
        }
    }
}

