/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.util.Preconditions;

public enum SqlGatewayRestAPIVersion implements RestAPIVersion<SqlGatewayRestAPIVersion>,
EndpointVersion
{
    V0(false, false),
    V1(false, true),
    V2(true, true);

    private final boolean isDefaultVersion;
    private final boolean isStable;

    private SqlGatewayRestAPIVersion(boolean isDefaultVersion, boolean isStable) {
        this.isDefaultVersion = isDefaultVersion;
        this.isStable = isStable;
    }

    @Override
    public String getURLVersionPrefix() {
        return this.name().toLowerCase();
    }

    @Override
    public boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    @Override
    public boolean isStableVersion() {
        return this.isStable;
    }

    public static SqlGatewayRestAPIVersion fromURIToVersion(String uri) {
        int slashIndex = uri.indexOf(47, 1);
        if (slashIndex < 0) {
            slashIndex = uri.length();
        }
        try {
            return SqlGatewayRestAPIVersion.valueOf(uri.substring(1, slashIndex).toUpperCase());
        }
        catch (Exception e) {
            return SqlGatewayRestAPIVersion.getDefaultVersion();
        }
    }

    public static List<SqlGatewayRestAPIVersion> getStableVersions() {
        return Arrays.stream(SqlGatewayRestAPIVersion.values()).filter(SqlGatewayRestAPIVersion::isStableVersion).collect(Collectors.toList());
    }

    public static SqlGatewayRestAPIVersion getDefaultVersion() {
        List versions = Arrays.stream(SqlGatewayRestAPIVersion.values()).filter(SqlGatewayRestAPIVersion::isDefaultVersion).collect(Collectors.toList());
        Preconditions.checkState(versions.size() == 1, String.format("Only one default version of Sql Gateway Rest API, but found %s.", versions.size()));
        return (SqlGatewayRestAPIVersion)versions.get(0);
    }
}

