/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class RegisteredBroadcastStateBackendMetaInfo<K, V>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final OperatorStateHandle.Mode assignmentMode;
    @Nonnull
    private final StateSerializerProvider<K> keySerializerProvider;
    @Nonnull
    private final StateSerializerProvider<V> valueSerializerProvider;

    public RegisteredBroadcastStateBackendMetaInfo(@Nonnull String name, @Nonnull OperatorStateHandle.Mode assignmentMode, @Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<V> valueSerializer) {
        this(name, assignmentMode, StateSerializerProvider.fromNewRegisteredSerializer(keySerializer), StateSerializerProvider.fromNewRegisteredSerializer(valueSerializer));
    }

    public RegisteredBroadcastStateBackendMetaInfo(@Nonnull RegisteredBroadcastStateBackendMetaInfo<K, V> copy) {
        this(Preconditions.checkNotNull(copy).name, copy.assignmentMode, copy.getKeySerializer().duplicate(), copy.getValueSerializer().duplicate());
    }

    public RegisteredBroadcastStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), OperatorStateHandle.Mode.valueOf(snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE)), StateSerializerProvider.fromPreviousSerializerSnapshot(Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.KEY_SERIALIZER))), StateSerializerProvider.fromPreviousSerializerSnapshot(Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER))));
        Preconditions.checkState(StateMetaInfoSnapshot.BackendStateType.BROADCAST == snapshot.getBackendStateType());
    }

    @Nonnull
    public RegisteredBroadcastStateBackendMetaInfo<K, V> deepCopy() {
        return new RegisteredBroadcastStateBackendMetaInfo<K, V>(this);
    }

    private RegisteredBroadcastStateBackendMetaInfo(@Nonnull String name, @Nonnull OperatorStateHandle.Mode assignmentMode, @Nonnull StateSerializerProvider<K> keySerializerProvider, @Nonnull StateSerializerProvider<V> valueSerializerProvider) {
        super(name);
        Preconditions.checkArgument(assignmentMode == OperatorStateHandle.Mode.BROADCAST);
        this.assignmentMode = assignmentMode;
        this.keySerializerProvider = keySerializerProvider;
        this.valueSerializerProvider = valueSerializerProvider;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Override
    @Nonnull
    public RegisteredBroadcastStateBackendMetaInfo<K, V> withSerializerUpgradesAllowed() {
        return new RegisteredBroadcastStateBackendMetaInfo<K, V>(this.snapshot());
    }

    @Nonnull
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<K> updateKeySerializer(TypeSerializer<K> newKeySerializer) {
        return this.keySerializerProvider.registerNewSerializerForRestoredState(newKeySerializer);
    }

    @Nullable
    public TypeSerializer<K> getPreviousKeySerializer() {
        return this.keySerializerProvider.previousSchemaSerializer();
    }

    @Nonnull
    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<V> updateValueSerializer(TypeSerializer<V> newValueSerializer) {
        return this.valueSerializerProvider.registerNewSerializerForRestoredState(newValueSerializer);
    }

    @Nullable
    public TypeSerializer<V> getPreviousValueSerializer() {
        return this.valueSerializerProvider.previousSchemaSerializer();
    }

    @Nonnull
    public OperatorStateHandle.Mode getAssignmentMode() {
        return this.assignmentMode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegisteredBroadcastStateBackendMetaInfo)) {
            return false;
        }
        RegisteredBroadcastStateBackendMetaInfo other = (RegisteredBroadcastStateBackendMetaInfo)obj;
        return Objects.equals(this.name, other.getName()) && Objects.equals((Object)this.assignmentMode, (Object)other.getAssignmentMode()) && Objects.equals(this.getKeySerializer(), other.getKeySerializer()) && Objects.equals(this.getValueSerializer(), other.getValueSerializer());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.assignmentMode.hashCode();
        result = 31 * result + this.getKeySerializer().hashCode();
        result = 31 * result + this.getValueSerializer().hashCode();
        return result;
    }

    public String toString() {
        return "RegisteredBroadcastBackendStateMetaInfo{name='" + this.name + '\'' + ", keySerializer=" + this.getKeySerializer() + ", valueSerializer=" + this.getValueSerializer() + ", assignmentMode=" + (Object)((Object)this.assignmentMode) + '}';
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.OPERATOR_STATE_DISTRIBUTION_MODE.toString(), this.assignmentMode.toString());
        HashMap<String, TypeSerializer<?>> serializerMap = CollectionUtil.newHashMapWithExpectedSize(2);
        HashMap<String, TypeSerializerSnapshot<?>> serializerConfigSnapshotsMap = CollectionUtil.newHashMapWithExpectedSize(2);
        String keySerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.KEY_SERIALIZER.toString();
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        TypeSerializer<K> keySerializer = this.getKeySerializer();
        serializerMap.put(keySerializerKey, keySerializer.duplicate());
        serializerConfigSnapshotsMap.put(keySerializerKey, keySerializer.snapshotConfiguration());
        TypeSerializer<V> valueSerializer = this.getValueSerializer();
        serializerMap.put(valueSerializerKey, valueSerializer.duplicate());
        serializerConfigSnapshotsMap.put(valueSerializerKey, valueSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.BROADCAST, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

