/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumerWithPartialRecordLength;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedApproximateSubpartitionView;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelinedApproximateSubpartition
extends PipelinedSubpartition {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedApproximateSubpartition.class);
    @GuardedBy(value="buffers")
    private boolean isPartialBufferCleanupRequired = false;

    PipelinedApproximateSubpartition(int index, int receiverExclusiveBuffersPerChannel, ResultPartition parent) {
        super(index, receiverExclusiveBuffersPerChannel, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferAvailabilityListener availabilityListener) {
        PrioritizedDeque prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            Preconditions.checkState(!this.isReleased);
            this.releaseView();
            LOG.debug("{}: Creating read view for subpartition {} of partition {}.", new Object[]{this.parent.getOwningTaskName(), this.getSubPartitionIndex(), this.parent.getPartitionId()});
            this.readView = new PipelinedApproximateSubpartitionView(this, availabilityListener);
        }
        return this.readView;
    }

    @Override
    Buffer buildSliceBuffer(BufferConsumerWithPartialRecordLength buffer) {
        if (this.isPartialBufferCleanupRequired) {
            this.isPartialBufferCleanupRequired = !buffer.cleanupPartialRecord();
        }
        return buffer.build();
    }

    private void releaseView() {
        assert (Thread.holdsLock(this.buffers));
        if (this.readView != null) {
            LOG.debug("Releasing view of subpartition {} of {}.", (Object)this.getSubPartitionIndex(), (Object)this.parent.getPartitionId());
            this.readView.releaseAllResources();
            this.readView = null;
            this.isPartialBufferCleanupRequired = true;
            this.isBlocked = false;
            this.sequenceNumber = 0;
        }
    }

    @Override
    public boolean isSupportChannelStateRecover() {
        return false;
    }

    @VisibleForTesting
    boolean isPartialBufferCleanupRequired() {
        return this.isPartialBufferCleanupRequired;
    }

    @VisibleForTesting
    void setIsPartialBufferCleanupRequired() {
        this.isPartialBufferCleanupRequired = true;
    }
}

